/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.web.ui.configuration;

import ch.admin.bit.jeap.errorhandling.web.ui.configuration.ConfigurationDTO;
import ch.admin.bit.jeap.errorhandling.web.ui.configuration.ErrorGroupConfigurationDTO;
import ch.admin.bit.jeap.errorhandling.web.ui.configuration.FrontendConfigProperties;
import ch.admin.bit.jeap.errorhandling.web.ui.configuration.LogDeepLinkProperties;
import ch.admin.bit.jeap.errorhandling.web.ui.configuration.VersionDetector;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Configuration")
@RestController
@RequestMapping(value={"/api/configuration"})
class ConfigurationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationController.class);
    private final FrontendConfigProperties frontendConfigProperties;
    private final LogDeepLinkProperties logDeepLinkProperties;
    @Value(value="${jeap.security.oauth2.resourceserver.authorization-server.issuer}")
    private String authority;

    @Schema(description="Returns the frontend configuration")
    @GetMapping
    public ConfigurationDTO getAuthConfiguration() {
        return ConfigurationDTO.builder().applicationUrl(this.frontendConfigProperties.getApplicationUrl()).pamsEnvironment(this.frontendConfigProperties.getPamsEnvironment()).logoutRedirectUri(this.frontendConfigProperties.getLogoutRedirectUri()).mockPams(this.frontendConfigProperties.getMockPams()).tokenAwarePatterns(this.frontendConfigProperties.getTokenAwarePattern()).appVersion(this.getVersion()).authority(this.authority).clientId(this.frontendConfigProperties.getClientId()).useAutoLogin(this.frontendConfigProperties.getAutoLogin()).redirectUrl(this.frontendConfigProperties.getRedirectUrl()).build();
    }

    @Schema(description="Returns the Version of the ErrorHandlingService")
    @GetMapping(value={"/version"})
    public String getVersion() {
        VersionDetector versionDetector = new VersionDetector();
        return versionDetector.getVersion();
    }

    @Schema(description="Returns the custom Log deeplink template")
    @GetMapping(value={"/log-deeplink"})
    public String getLogDeepLink() {
        return this.logDeepLinkProperties.getBaseUrl();
    }

    @Schema(description="Returns the base link for jira tickets")
    @GetMapping(value={"/ticket-number"})
    public ErrorGroupConfigurationDTO getTicketNumber() {
        return ErrorGroupConfigurationDTO.builder().ticketingSystemUrl(this.frontendConfigProperties.getTicketingSystemUrl()).build();
    }

    @Generated
    public ConfigurationController(FrontendConfigProperties frontendConfigProperties, LogDeepLinkProperties logDeepLinkProperties) {
        this.frontendConfigProperties = frontendConfigProperties;
        this.logDeepLinkProperties = logDeepLinkProperties;
    }
}

