/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.manualtask;

import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskDto;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskManagementException;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskManagementServiceProperties;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskStateDto;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskStatus;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskTypDto;
import ch.admin.bit.jeap.security.restclient.JeapOAuth2RestClientBuilderFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.ClientHttpRequestFactories;
import org.springframework.boot.web.client.ClientHttpRequestFactorySettings;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClient;

@Component
public class TaskManagementClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskManagementClient.class);
    private static final String TASKS_ENDPOINT = "api/tasks";
    private static final String TASKS_CONFIG_ENDPOINT = "api/task-configs";
    private final RestClient restClient;
    private final TaskManagementServiceProperties taskManagementServiceProperties;
    private List<TaskTypDto> taskTypesToInitialize = null;

    TaskManagementClient(JeapOAuth2RestClientBuilderFactory jeapOAuth2RestClientBuilderFactory, TaskManagementServiceProperties taskManagementServiceProperties) {
        this.taskManagementServiceProperties = taskManagementServiceProperties;
        if (this.taskManagementServiceProperties.isEnabled()) {
            ClientHttpRequestFactory requestFactory = ClientHttpRequestFactories.get((ClientHttpRequestFactorySettings)ClientHttpRequestFactorySettings.DEFAULTS.withReadTimeout(taskManagementServiceProperties.getTimeout()));
            this.restClient = jeapOAuth2RestClientBuilderFactory.createForClientRegistryId(this.taskManagementServiceProperties.getClientId()).requestFactory(requestFactory).baseUrl(this.taskManagementServiceProperties.getUrl()).requestInterceptor(TaskManagementClient::logRequest).build();
        } else {
            this.restClient = null;
        }
    }

    private static ClientHttpResponse logRequest(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Task Management Request: {} {}", (Object)StructuredArguments.keyValue((String)"method", (Object)request.getMethod()), (Object)StructuredArguments.keyValue((String)"url", (Object)request.getURI()));
        }
        return execution.execute(request, body);
    }

    public synchronized void lazilyInitializeTaskTypes(List<TaskTypDto> taskTypeDtos) {
        log.info("Got task type definitions to lazily initialize at Agir: {}.", taskTypeDtos);
        this.taskTypesToInitialize = new ArrayList<TaskTypDto>(taskTypeDtos);
    }

    public void createTaskTypes(List<TaskTypDto> taskTypeDtos) {
        log.debug("Creating task types {}.", taskTypeDtos);
        if (this.taskManagementServiceProperties.isEnabled()) {
            try {
                this.putTaskTypes(taskTypeDtos);
            }
            catch (Exception e) {
                this.rethrowAsTaskManagementException("Could not create task types at task management service", e);
            }
        } else {
            log.info("Task Management Service is disabled: Task types {} not created.", taskTypeDtos);
        }
    }

    public void createTask(TaskDto taskDto) {
        log.debug("Creating task {}.", (Object)taskDto);
        this.lazyTaskTypesInitialization();
        if (this.taskManagementServiceProperties.isEnabled()) {
            try {
                this.putTask(taskDto);
            }
            catch (Exception e) {
                this.rethrowAsTaskManagementException("Could not create task at task management service", e);
            }
        } else {
            log.info("Task Management Service is disabled: Task {} not created.", (Object)taskDto);
        }
    }

    public void closeTask(UUID taskId) {
        log.debug("Closing task with id '{}'.", (Object)taskId);
        if (this.taskManagementServiceProperties.isEnabled()) {
            try {
                this.putTaskClosed(taskId.toString());
            }
            catch (Exception e) {
                this.rethrowAsTaskManagementException("Could not close task at task management service", e);
            }
        } else {
            log.info("Task Management Service is disabled: Task with id '{}' not closed.", (Object)taskId);
        }
    }

    private synchronized void lazyTaskTypesInitialization() {
        if (this.taskTypesToInitialize != null) {
            log.info("Starting lazy initialization of task types {}.", this.taskTypesToInitialize);
            this.createTaskTypes(this.taskTypesToInitialize);
            log.info("Ended lazy initialization of task types {}.", this.taskTypesToInitialize);
            this.taskTypesToInitialize = null;
        }
    }

    private void rethrowAsTaskManagementException(String errorMessage, Exception exception) {
        if (exception instanceof TaskManagementException) {
            TaskManagementException taskManagementException = (TaskManagementException)exception;
            throw taskManagementException;
        }
        throw new TaskManagementException(errorMessage, exception);
    }

    private void putTask(TaskDto taskDto) {
        log.debug("Trying to create or update the task {}", (Object)taskDto);
        try {
            ((RestClient.RequestBodySpec)this.restClient.put().uri("api/tasks/{id}", new Object[]{taskDto.getId()})).contentType(MediaType.APPLICATION_JSON).body((Object)taskDto).retrieve().toBodilessEntity();
            log.info("Successfully created or updated the task {}.", (Object)taskDto);
        }
        catch (Exception e) {
            log.error("Failed to create or update the task {} because of an exception:", (Object)taskDto, (Object)e);
            throw e;
        }
    }

    private void putTaskClosed(String taskId) {
        log.debug("Trying to close the task with id '{}'", (Object)taskId);
        TaskStateDto taskStateDto = new TaskStateDto(TaskStatus.CLOSED);
        try {
            ((RestClient.RequestBodySpec)this.restClient.put().uri("api/tasks/{id}/state", new Object[]{taskId})).contentType(MediaType.APPLICATION_JSON).body((Object)taskStateDto).retrieve().onStatus(httpStatus -> httpStatus.isSameCodeAs((HttpStatusCode)HttpStatus.NOT_FOUND), (request, response) -> log.warn("Task with id '{}' could not be closed as it no longer exists", (Object)taskId)).toBodilessEntity();
            log.info("Successfully closed the task with id '{}'.", (Object)taskId);
        }
        catch (Exception e) {
            log.error("Failed to close the task with id '{}' because of an exception:", (Object)taskId, (Object)e);
            throw e;
        }
    }

    private void putTaskTypes(List<TaskTypDto> taskTypes) {
        log.debug("Trying to create or update the task types {}.", taskTypes);
        try {
            ((RestClient.RequestBodySpec)this.restClient.put().uri(TASKS_CONFIG_ENDPOINT, new Object[0])).contentType(MediaType.APPLICATION_JSON).body(taskTypes).retrieve().toBodilessEntity();
            log.info("Successfully created or updated the task types {}.", taskTypes);
        }
        catch (Exception e) {
            log.warn("Failed to create of update the task types {} because of an exception:", taskTypes, (Object)e);
            throw e;
        }
    }
}

