/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.resend.strategy;

import ch.admin.bit.jeap.errorhandling.domain.resend.strategy.DefaultResendingStrategyConfigProperties;
import ch.admin.bit.jeap.errorhandling.domain.resend.strategy.ResendingStrategy;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorEventData;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.EventMessage;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.EventMetadata;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultResendingStrategy
implements ResendingStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultResendingStrategy.class);
    private final DefaultResendingStrategyConfigProperties resendSchedulerConfigProperties;

    @Override
    public Optional<ZonedDateTime> determineResend(int errorCountForEvent, EventMetadata eventMetadata, EventMetadata errorEventMetadata, ErrorEventData errorEventData, EventMessage message) {
        if (errorCountForEvent < this.resendSchedulerConfigProperties.getMaxRetries()) {
            ZonedDateTime resendAt = ZonedDateTime.now().plus(this.computeDelay(errorCountForEvent));
            log.debug("Current error count for event {} is {} therefore resend it at {}", new Object[]{eventMetadata.getId(), errorCountForEvent, resendAt});
            return Optional.of(resendAt);
        }
        log.debug("Current error count for event {} is {}, do not resend it no more", (Object)eventMetadata.getId(), (Object)errorCountForEvent);
        return Optional.empty();
    }

    Duration computeDelay(int currentRetryCount) {
        Duration delay = this.resendSchedulerConfigProperties.getDelay();
        if (this.resendSchedulerConfigProperties.isExponentialBackoffEnabled()) {
            for (int i = 0; i < currentRetryCount; ++i) {
                if ((delay = delay.multipliedBy(this.resendSchedulerConfigProperties.getExponentialBackoffFactor())).compareTo(this.resendSchedulerConfigProperties.getExponentialBackoffMaxDelay()) < 0) continue;
                delay = this.resendSchedulerConfigProperties.getExponentialBackoffMaxDelay();
                break;
            }
        }
        return delay;
    }

    @Generated
    public DefaultResendingStrategy(DefaultResendingStrategyConfigProperties resendSchedulerConfigProperties) {
        this.resendSchedulerConfigProperties = resendSchedulerConfigProperties;
    }
}

