/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.error;

import ch.admin.bit.jeap.errorhandling.domain.error.ErrorList;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorRepository;
import ch.admin.bit.jeap.errorhandling.web.api.ErrorSearchCriteria;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class ErrorSearchService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorSearchService.class);
    private final ErrorRepository errorRepository;

    public ErrorList search(ErrorSearchCriteria criteria) {
        Page<Error> errors = this.errorRepository.search(criteria, criteria.getPageable());
        return new ErrorList(errors.getTotalElements(), errors.getContent());
    }

    @Cacheable(value={"eventSources"})
    public List<String> getAllEventSources() {
        return this.errorRepository.getAllEventSources();
    }

    @Cacheable(value={"errorCodes"})
    public List<String> getAllErrorCodes() {
        return this.errorRepository.getAllErrorCodes();
    }

    @Cacheable(value={"eventNames"})
    public List<String> getAllEventNames() {
        return this.errorRepository.getAllEventNames();
    }

    @Generated
    public ErrorSearchService(ErrorRepository errorRepository) {
        this.errorRepository = errorRepository;
    }
}

