/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.persistence;

import jakarta.persistence.Embeddable;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.util.StringUtils;

@Embeddable
public class EventMessage {
    @NonNull
    private byte[] payload;
    private byte[] key;
    @NonNull
    private String topic;
    private String clusterName;
    private long partition;
    private long offset;

    public String getClusterNameOrDefault(String defaultClusterName) {
        return StringUtils.hasText((String)this.clusterName) ? this.clusterName : defaultClusterName;
    }

    @Generated
    public static EventMessageBuilder builder() {
        return new EventMessageBuilder();
    }

    @NonNull
    @Generated
    public byte[] getPayload() {
        return this.payload;
    }

    @Generated
    public byte[] getKey() {
        return this.key;
    }

    @NonNull
    @Generated
    public String getTopic() {
        return this.topic;
    }

    @Generated
    public String getClusterName() {
        return this.clusterName;
    }

    @Generated
    public long getPartition() {
        return this.partition;
    }

    @Generated
    public long getOffset() {
        return this.offset;
    }

    @Generated
    EventMessage(@NonNull byte[] payload, byte[] key, @NonNull String topic, String clusterName, long partition, long offset) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (topic == null) {
            throw new NullPointerException("topic is marked non-null but is null");
        }
        this.payload = payload;
        this.key = key;
        this.topic = topic;
        this.clusterName = clusterName;
        this.partition = partition;
        this.offset = offset;
    }

    @Generated
    public EventMessage() {
    }

    @Generated
    public String toString() {
        return "EventMessage(topic=" + this.getTopic() + ", clusterName=" + this.getClusterName() + ", partition=" + this.getPartition() + ", offset=" + this.getOffset() + ")";
    }

    @Generated
    public static class EventMessageBuilder {
        @Generated
        private byte[] payload;
        @Generated
        private byte[] key;
        @Generated
        private String topic;
        @Generated
        private String clusterName;
        @Generated
        private long partition;
        @Generated
        private long offset;

        @Generated
        EventMessageBuilder() {
        }

        @Generated
        public EventMessageBuilder payload(@NonNull byte[] payload) {
            if (payload == null) {
                throw new NullPointerException("payload is marked non-null but is null");
            }
            this.payload = payload;
            return this;
        }

        @Generated
        public EventMessageBuilder key(byte[] key) {
            this.key = key;
            return this;
        }

        @Generated
        public EventMessageBuilder topic(@NonNull String topic) {
            if (topic == null) {
                throw new NullPointerException("topic is marked non-null but is null");
            }
            this.topic = topic;
            return this;
        }

        @Generated
        public EventMessageBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        @Generated
        public EventMessageBuilder partition(long partition) {
            this.partition = partition;
            return this;
        }

        @Generated
        public EventMessageBuilder offset(long offset) {
            this.offset = offset;
            return this;
        }

        @Generated
        public EventMessage build() {
            return new EventMessage(this.payload, this.key, this.topic, this.clusterName, this.partition, this.offset);
        }

        @Generated
        public String toString() {
            return "EventMessage.EventMessageBuilder(payload=" + Arrays.toString(this.payload) + ", key=" + Arrays.toString(this.key) + ", topic=" + this.topic + ", clusterName=" + this.clusterName + ", partition=" + this.partition + ", offset=" + this.offset + ")";
        }
    }
}

