/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.user;

import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.User;
import ch.admin.bit.jeap.security.resource.semanticAuthentication.ServletSemanticAuthorization;
import ch.admin.bit.jeap.security.resource.token.JeapAuthenticationContext;
import ch.admin.bit.jeap.security.resource.token.JeapAuthenticationToken;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserService.class);
    private final ServletSemanticAuthorization jeapSemanticAuthorization;

    public Optional<User> getAuthenticatedUser() {
        return this.getJeapAuthenticationToken().map(UserService::createUser);
    }

    private Optional<JeapAuthenticationToken> getJeapAuthenticationToken() {
        try {
            return Optional.ofNullable(this.jeapSemanticAuthorization.getAuthenticationToken());
        }
        catch (Exception e) {
            log.debug("Unable to get JeapAuthenticationToken for user.", (Throwable)e);
            return Optional.empty();
        }
    }

    private static User createUser(JeapAuthenticationToken jeapAuthenticationToken) {
        JeapAuthenticationContext context = jeapAuthenticationToken.getJeapAuthenticationContext();
        if (JeapAuthenticationContext.USER == context) {
            return User.builder().authContext(context.name()).subject(jeapAuthenticationToken.getTokenSubject()).extId(jeapAuthenticationToken.getTokenExtId()).givenName(jeapAuthenticationToken.getTokenGivenName()).familyName(jeapAuthenticationToken.getTokenFamilyName()).build();
        }
        return User.builder().authContext(context.name()).subject(jeapAuthenticationToken.getTokenSubject()).build();
    }

    @Generated
    public UserService(ServletSemanticAuthorization jeapSemanticAuthorization) {
        this.jeapSemanticAuthorization = jeapSemanticAuthorization;
    }
}

