/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.manualtask.taskFactory;

import ch.admin.bit.jeap.errorhandling.domain.manualtask.taskFactory.DefaultTaskFactoryProperties;
import ch.admin.bit.jeap.errorhandling.domain.manualtask.taskFactory.TaskFactory;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskDto;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskManagementClient;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskManagementException;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskManagementServiceProperties;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskReferenceDto;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskStatus;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskTypDto;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskTypeDisplayDto;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import jakarta.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;

public class DefaultTaskFactory
implements TaskFactory {
    private static final String TYPE = "errorhandling";
    private final DefaultTaskFactoryProperties taskFactoryProperties;
    private final TaskManagementServiceProperties taskManagementServiceProperties;
    private final TaskManagementClient taskManagementClient;

    @PostConstruct
    public void createTaskTypes() throws TaskManagementException {
        if (!this.taskManagementServiceProperties.isEnabled()) {
            return;
        }
        this.taskFactoryProperties.validate();
        List<TaskTypeDisplayDto> taskTypeDisplayDtos = this.taskFactoryProperties.getDisplay().entrySet().stream().map(entry -> DefaultTaskFactory.toTaskTypeDisplayDto((String)entry.getKey(), (DefaultTaskFactoryProperties.TaskDisplayProperties)entry.getValue())).collect(Collectors.toList());
        TaskTypDto errorType = TaskTypDto.builder().name(TYPE).system(this.taskFactoryProperties.getSystem()).display(taskTypeDisplayDtos).domain(this.taskFactoryProperties.getDomain()).build();
        this.taskManagementClient.lazilyInitializeTaskTypes(Collections.singletonList(errorType));
    }

    private static TaskTypeDisplayDto toTaskTypeDisplayDto(String language, DefaultTaskFactoryProperties.TaskDisplayProperties displayProperties) {
        return TaskTypeDisplayDto.builder().language(language.toUpperCase()).title(displayProperties.getTitle()).description(displayProperties.getDescription()).displayName(displayProperties.getDisplayName()).displayDomain(displayProperties.getDisplayDomain()).build();
    }

    @Override
    public TaskDto create(Error error) {
        TaskReferenceDto errorServiceReference = TaskReferenceDto.builder().name(this.taskFactoryProperties.getTaskReferenceName()).uri(this.taskFactoryProperties.getErrorServiceBaseUrl() + String.valueOf(error.getId())).build();
        return TaskDto.builder().id(UUID.randomUUID()).type(TYPE).system(this.taskFactoryProperties.getSystem()).service(error.getCausingEventMetadata().getPublisher().getService()).state(TaskStatus.OPEN).priority(this.taskFactoryProperties.getPriority()).due(LocalDateTime.now().plus(this.taskFactoryProperties.getTimeToHandle())).reference(errorServiceReference).build();
    }

    @Generated
    public DefaultTaskFactory(DefaultTaskFactoryProperties taskFactoryProperties, TaskManagementServiceProperties taskManagementServiceProperties, TaskManagementClient taskManagementClient) {
        this.taskFactoryProperties = taskFactoryProperties;
        this.taskManagementServiceProperties = taskManagementServiceProperties;
        this.taskManagementClient = taskManagementClient;
    }
}

