/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.housekeeping;

import ch.admin.bit.jeap.errorhandling.domain.housekeeping.HouseKeepingServiceConfigProperties;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.AuditLogRepository;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.CausingEventRepository;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorGroupRepository;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorQueryResult;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorRepository;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ScheduledResendRepository;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class RepositoryHousekeeping {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RepositoryHousekeeping.class);
    public static final List<Error.ErrorState> ERROR_STATES = List.of(Error.ErrorState.TEMPORARY_RETRIED, Error.ErrorState.PERMANENT_RETRIED, Error.ErrorState.DELETED, Error.ErrorState.PERMANENT);
    private final ErrorRepository errorRepository;
    private final ErrorGroupRepository errorGroupRepository;
    private final CausingEventRepository causingEventRepository;
    private final ScheduledResendRepository scheduledResendRepository;
    private final AuditLogRepository auditLogRepository;
    private final HouseKeepingServiceConfigProperties configProperties;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean deleteErrorsOlderThan(ZonedDateTime olderThan) {
        Slice<ErrorQueryResult> resultPage = this.errorRepository.findIdByStateInAndCreatedBefore(ERROR_STATES, olderThan, Pageable.ofSize((int)this.configProperties.getPageSize()));
        log.info("Housekeeping: found {} errors to delete", (Object)resultPage.getNumberOfElements());
        Set<UUID> errorIds = resultPage.toSet().stream().map(ErrorQueryResult::getId).collect(Collectors.toSet());
        log.info("Housekeeping: delete scheduled resends...");
        this.scheduledResendRepository.deleteAllByErrorIdIn(errorIds);
        log.info("Housekeeping: delete audit logs...");
        this.auditLogRepository.deleteAllByErrorIdIn(errorIds);
        log.info("Housekeeping: delete errors...");
        this.errorRepository.deleteAllById(errorIds);
        log.info("Housekeeping: deleted {} errors", (Object)errorIds.size());
        return resultPage.hasNext();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean deleteCausingEventsWithoutRelatedErrors() {
        Slice<UUID> resultPage = this.causingEventRepository.findCausingEventIdsWithoutError(Pageable.ofSize((int)this.configProperties.getPageSize()));
        log.info("Housekeeping: found {} causing events to delete", (Object)resultPage.getNumberOfElements());
        log.info("Housekeeping: delete causing events...");
        this.causingEventRepository.deleteAllHeadersByCausingEventIds(resultPage.getContent());
        this.causingEventRepository.deleteAllById(resultPage.getContent());
        log.info("Housekeeping: causing events deleted");
        return resultPage.hasNext();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean deleteErrorGroupsNotReferencedByAnyError() {
        Slice<UUID> resultPage = this.errorGroupRepository.findUnreferencedErrorGroups(Pageable.ofSize((int)this.configProperties.getPageSize()));
        log.info("Housekeeping: found {} error groups to delete", (Object)resultPage.getNumberOfElements());
        log.info("Housekeeping: delete error groups...");
        this.errorGroupRepository.deleteAllById(resultPage.getContent());
        log.info("Housekeeping: error groups deleted");
        return resultPage.hasNext();
    }

    @Generated
    public RepositoryHousekeeping(ErrorRepository errorRepository, ErrorGroupRepository errorGroupRepository, CausingEventRepository causingEventRepository, ScheduledResendRepository scheduledResendRepository, AuditLogRepository auditLogRepository, HouseKeepingServiceConfigProperties configProperties) {
        this.errorRepository = errorRepository;
        this.errorGroupRepository = errorGroupRepository;
        this.causingEventRepository = causingEventRepository;
        this.scheduledResendRepository = scheduledResendRepository;
        this.auditLogRepository = auditLogRepository;
        this.configProperties = configProperties;
    }
}

