/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.persistence;

import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupAggregatedData;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorGroup;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ErrorGroupRepository
extends JpaRepository<ErrorGroup, UUID> {
    public static final String ERROR_GROUP_AGGREGATED_DATA_SELECTOR = "    SELECT eg.id as groupId, eg.created as groupCreatedAt, count(e.id) as errorCount,\n        eg.eventName as errorEvent, eg.errorPublisher as errorPublisher,\n        eg.errorCode as errorCode,\n        eg.errorStackTraceHash as stackTraceHash,\n        eg.errorMessage as errorMessage,\n        min(e.created) as firstErrorAt,\n        max(e.created) as latestErrorAt,\n        eg.ticketNumber as ticketNumber, eg.freeText as freeText\n    FROM Error e\n    JOIN e.errorGroup eg\n    WHERE e.state IN ('SEND_TO_MANUALTASK', 'PERMANENT')\n";
    public static final String ERROR_GROUP_AGGREGATED_DATA_GROUPING = " GROUP BY eg.id, eg.eventName, eg.errorPublisher, eg.errorCode, eg.errorMessage, eg.freeText, eg.ticketNumber ";

    @Query(value="    SELECT eg.id as groupId, eg.created as groupCreatedAt, count(e.id) as errorCount,\n        eg.eventName as errorEvent, eg.errorPublisher as errorPublisher,\n        eg.errorCode as errorCode,\n        eg.errorStackTraceHash as stackTraceHash,\n        eg.errorMessage as errorMessage,\n        min(e.created) as firstErrorAt,\n        max(e.created) as latestErrorAt,\n        eg.ticketNumber as ticketNumber, eg.freeText as freeText\n    FROM Error e\n    JOIN e.errorGroup eg\n    WHERE e.state IN ('SEND_TO_MANUALTASK', 'PERMANENT')\n AND (:noTicket = true AND (eg.ticketNumber IS NULL OR eg.ticketNumber = '') OR :noTicket = false) AND (CAST(:dateFrom AS TIMESTAMP) IS NULL OR e.created >= CAST(:dateFrom AS TIMESTAMP)) AND (CAST(:dateTo AS TIMESTAMP) IS NULL OR e.created <= CAST(:dateTo AS TIMESTAMP)) AND ((:source IS NULL OR :source = '') OR eg.errorPublisher = :source) AND ((:messageType IS NULL OR :messageType = '') OR eg.eventName = :messageType) AND ((:errorCode IS NULL OR :errorCode = '') OR eg.errorCode = :errorCode) AND ((:jiraTicket IS NULL OR :jiraTicket = '') OR eg.ticketNumber = :jiraTicket)  GROUP BY eg.id, eg.eventName, eg.errorPublisher, eg.errorCode, eg.errorMessage, eg.freeText, eg.ticketNumber  order by errorCount desc  offset :#{#pageable.offset} rows  fetch next :#{#pageable.pageSize} rows only", countQuery="select count(*) from ErrorGroup")
    public Page<ErrorGroupAggregatedData> findErrorGroupAggregatedData(@Param(value="noTicket") Boolean var1, @Param(value="dateFrom") ZonedDateTime var2, @Param(value="dateTo") ZonedDateTime var3, @Param(value="source") String var4, @Param(value="messageType") String var5, @Param(value="errorCode") String var6, @Param(value="jiraTicket") String var7, Pageable var8);

    @Query(value="    SELECT eg.id as groupId, eg.created as groupCreatedAt, count(e.id) as errorCount,\n        eg.eventName as errorEvent, eg.errorPublisher as errorPublisher,\n        eg.errorCode as errorCode,\n        eg.errorStackTraceHash as stackTraceHash,\n        eg.errorMessage as errorMessage,\n        min(e.created) as firstErrorAt,\n        max(e.created) as latestErrorAt,\n        eg.ticketNumber as ticketNumber, eg.freeText as freeText\n    FROM Error e\n    JOIN e.errorGroup eg\n    WHERE e.state IN ('SEND_TO_MANUALTASK', 'PERMANENT')\n AND eg.id = :id  GROUP BY eg.id, eg.eventName, eg.errorPublisher, eg.errorCode, eg.errorMessage, eg.freeText, eg.ticketNumber ")
    public Optional<ErrorGroupAggregatedData> findErrorGroupAggregatedData(@Param(value="id") UUID var1);

    public Optional<ErrorGroup> findByErrorPublisherAndErrorCodeAndEventNameAndErrorStackTraceHash(String var1, String var2, String var3, String var4);

    @Query(value="select errorGroup.id from ErrorGroup errorGroup left join Error error on errorGroup.id = error.errorGroup.id where error is null")
    public Slice<UUID> findUnreferencedErrorGroups(Pageable var1);

    public boolean existsByTicketNumber(String var1);

    @Query(value="select count(eg) from ErrorGroup eg where exists (\n    select e from Error e\n        where e.errorGroup = eg\n            and e.state in (:states))\n")
    public int countErrorGroupsWithErrorsInStates(Set<Error.ErrorState> var1);
}

