/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.persistence;

import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ScheduledResend;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ScheduledResendRepository
extends JpaRepository<ScheduledResend, UUID> {
    @Query(value="select sr from ScheduledResend sr where sr.resentAt is null and not sr.cancelled = TRUE and sr.resendAt <= ?1 order by sr.resendAt")
    public List<ScheduledResend> findNextScheduledResendsOldestFirst(ZonedDateTime var1, Pageable var2);

    default public List<ScheduledResend> findNextScheduledResendsOldestFirst(ZonedDateTime notAfter, int maxNumItemsToFind) {
        return this.findNextScheduledResendsOldestFirst(notAfter, (Pageable)PageRequest.of((int)0, (int)maxNumItemsToFind));
    }

    public List<ScheduledResend> findByErrorId(UUID var1);

    public Optional<ScheduledResend> findFirstByErrorIdAndCancelledIsFalseAndResentAtIsNullOrderByResendAtAsc(UUID var1);

    default public Optional<ScheduledResend> findNextScheduledResend(UUID errorId) {
        return this.findFirstByErrorIdAndCancelledIsFalseAndResentAtIsNullOrderByResendAtAsc(errorId);
    }

    @Modifying
    @Query(nativeQuery=true, value="DELETE FROM scheduled_resend sr WHERE sr.error_id in (:errorIds) ")
    public void deleteAllByErrorIdIn(@Param(value="errorIds") Set<UUID> var1);
}

