/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.manualtask.resend;

import ch.admin.bit.jeap.errorhandling.domain.error.ErrorService;
import ch.admin.bit.jeap.errorhandling.domain.manualtask.resend.TasksSynchronizeProperties;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import net.javacrumbs.shedlock.core.LockAssert;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
class TasksSynchronize {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TasksSynchronize.class);
    private final ErrorService errorService;
    private final TasksSynchronizeProperties tasksSynchronizeProperties;

    @Scheduled(cron="#{@tasksSynchronizeProperties.cronExpression}")
    @SchedulerLock(name="sync-pending-tasks", lockAtLeastFor="#{@tasksSynchronizeProperties.lockAtLeast.toString()}", lockAtMostFor="#{@tasksSynchronizeProperties.lockAtMost.toString()}")
    public void syncWithManualTask() {
        LockAssert.assertLocked();
        this.syncState(Error.ErrorState.SEND_TO_MANUALTASK, this.errorService::createManualTask, "opened");
        this.syncState(Error.ErrorState.RESOLVE_ON_MANUALTASK, this.errorService::closeManualTask, "resolved");
        this.syncState(Error.ErrorState.DELETE_ON_MANUALTASK, this.errorService::deleteManualTask, "deleted");
    }

    private void syncState(Error.ErrorState state, Consumer<Error> handler, String action) {
        int processedChunks = 0;
        while (processedChunks < this.tasksSynchronizeProperties.getMaxConsecutiveChunks()) {
            log.trace("Fetching at max {} errors not yet {} at manual task service.", (Object)this.tasksSynchronizeProperties.getMaxResendChunkSize(), (Object)action);
            List<Error> chunk = this.errorService.getErrorListByState(state, 0, this.tasksSynchronizeProperties.getMaxResendChunkSize()).getErrors();
            log.debug("Got {} tasks not yet {}", (Object)chunk.size(), (Object)action);
            chunk.forEach(handler);
            if (++processedChunks >= this.tasksSynchronizeProperties.getMaxResendChunkSize()) continue;
            log.trace("As not full, this was the last page");
            return;
        }
        log.debug("Maximum number of consecutive chunks reached. Proceeding at next execution...");
    }

    @Generated
    public TasksSynchronize(ErrorService errorService, TasksSynchronizeProperties tasksSynchronizeProperties) {
        this.errorService = errorService;
        this.tasksSynchronizeProperties = tasksSynchronizeProperties;
    }
}

