/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.kafka;

import ch.admin.bit.jeap.domainevent.avro.error.EventProcessingFailedEvent;
import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.ErrorEventHandler;
import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.ExceptionCauseChainChecker;
import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.FatalEhsProcessingException;
import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.RecoverableEhsProcessingException;
import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.converters.ProcessingFailedEventConverter;
import ch.admin.bit.jeap.messaging.avro.errorevent.MessageProcessingFailedEvent;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import java.util.List;
import lombok.Generated;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NestedExceptionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.support.Acknowledgment;

class MessageProcessingFailedEventListener
implements AcknowledgingMessageListener<Object, SpecificRecordBase> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageProcessingFailedEventListener.class);
    private static final List<Class<? extends Throwable>> RECOVERABLE_EXCEPTIONS = List.of(DataAccessResourceFailureException.class, QueryTimeoutException.class, PessimisticLockingFailureException.class, org.hibernate.QueryTimeoutException.class, LockAcquisitionException.class, JDBCConnectionException.class, SQLTransientException.class, SQLTransientConnectionException.class);
    private final ProcessingFailedEventConverter processingFailedEventConverter;
    private final ErrorEventHandler errorEventHandler;
    private final String clusterName;

    public void onMessage(ConsumerRecord<Object, SpecificRecordBase> data, Acknowledgment acknowledgment) {
        try {
            this.consume((SpecificRecordBase)data.value());
        }
        catch (Exception e) {
            RuntimeException rte = this.mapException(e);
            log.error("An error occurred during the processing of a failed message.", (Throwable)rte);
            throw rte;
        }
        acknowledgment.acknowledge();
    }

    private void consume(SpecificRecordBase errorEvent) {
        MessageProcessingFailedEvent messageProcessingFailedEvent = errorEvent instanceof EventProcessingFailedEvent ? this.processingFailedEventConverter.convert((EventProcessingFailedEvent)errorEvent) : (MessageProcessingFailedEvent)errorEvent;
        this.errorEventHandler.handle(this.clusterName, messageProcessingFailedEvent);
    }

    private RuntimeException mapException(Throwable t) {
        if (ExceptionCauseChainChecker.containsCauseType(t, RECOVERABLE_EXCEPTIONS) || this.isTxOrDbReadOnlyException(t)) {
            return new RecoverableEhsProcessingException(t);
        }
        return new FatalEhsProcessingException(t);
    }

    private boolean isTxOrDbReadOnlyException(Throwable t) {
        if (t instanceof DataAccessException) {
            SQLException sqlEx;
            DataAccessException dae = (DataAccessException)t;
            Throwable rootCause = NestedExceptionUtils.getMostSpecificCause((Throwable)dae);
            return rootCause instanceof SQLException && "25006".equals((sqlEx = (SQLException)rootCause).getSQLState());
        }
        return false;
    }

    @Generated
    public MessageProcessingFailedEventListener(ProcessingFailedEventConverter processingFailedEventConverter, ErrorEventHandler errorEventHandler, String clusterName) {
        this.processingFailedEventConverter = processingFailedEventConverter;
        this.errorEventHandler = errorEventHandler;
        this.clusterName = clusterName;
    }
}

