/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.web.ui;

import ch.admin.bit.jeap.errorhandling.web.ui.configuration.FrontendConfigProperties;
import ch.admin.bit.jeap.starter.application.web.FrontendRouteRedirectExceptionHandler;
import lombok.Generated;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
class FrontendWebConfig
implements WebMvcConfigurer {
    private final FrontendConfigProperties frontendConfigProperties;

    public void addCorsMappings(CorsRegistry registry) {
        String origin = this.getOrigin();
        registry.addMapping("/**").allowedHeaders(new String[]{"*"}).allowedMethods(new String[]{"*"}).allowedOrigins(new String[]{origin}).allowCredentials(false);
    }

    String getOrigin() {
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)this.frontendConfigProperties.getApplicationUrl()).build();
        Object origin = "%s://%s".formatted(uriComponents.getScheme(), uriComponents.getHost());
        if (uriComponents.getPort() != -1) {
            origin = (String)origin + ":" + uriComponents.getPort();
        }
        return origin;
    }

    @Bean
    public FrontendRouteRedirectExceptionHandler frontendRouteRedirectExceptionHandler() {
        return new FrontendRouteRedirectExceptionHandler();
    }

    @Generated
    public FrontendWebConfig(FrontendConfigProperties frontendConfigProperties) {
        this.frontendConfigProperties = frontendConfigProperties;
    }
}

