/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.metrics;

import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorGroupRepository;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorRepository;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.PostConstruct;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ErrorHandlingMetricsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorHandlingMetricsService.class);
    private static final String TEMP_RETRY_PENDING_GAUGE_METRIC = "eh_temporary_retry_pending";
    private static final String PERM_ERROR_OPEN_GAUGE_METRIC = "eh_permanent_open";
    private static final String PENDING_MANUALTASK_CREATE_ERRORS_GAUGE_METRIC = "eh_permanent_pending_manualtask_create";
    private static final String PENDING_MANUALTASK_RESOLVE_ERRORS_GAUGE_METRIC = "eh_permanent_pending_manualtask_resolve";
    private static final String PENDING_MANUALTASK_DELETE_ERRORS_GAUGE_METRIC = "eh_permanent_pending_manualtask_delete";
    private static final String CREATED_TEMPORARY_ERRORS_COUNTER_METRIC = "eh_created_temporary_errors";
    private static final String CREATED_PERMANENT_ERRORS_COUNTER_METRIC = "eh_created_permanent_errors";
    public static final String CAUSING_SERVICE_TAG = "causing_service";
    private static final String ERROR_GROUPS_WITH_OPEN_ERRORS_GAUGE_METRIC = "eh_error_groups_with_open_errors";
    private static final Set<Error.ErrorState> OPEN_ERROR_STATES = Set.of(Error.ErrorState.PERMANENT, Error.ErrorState.SEND_TO_MANUALTASK);
    private final MeterRegistry meterRegistry;
    private final ErrorRepository errorRepository;
    private final ErrorGroupRepository errorGroupRepository;
    private int temporaryRetryPendingErrorCount = -1;
    private int pendingManualTaskCreationErrorCount = -1;
    private int openPermanentErrorCount = -1;
    private int resolveOnManualTaskErrorCount = -1;
    private int deleteOnManualTaskErrorCount = -1;
    private int errorGroupsWithOpenErrors = -1;
    private Counter createdTemporaryErrors;

    @PostConstruct
    void initialize() {
        this.updateGauges();
        Gauge.builder((String)TEMP_RETRY_PENDING_GAUGE_METRIC, () -> this.temporaryRetryPendingErrorCount).description("Temporary errors with pending retry").register(this.meterRegistry);
        Gauge.builder((String)PERM_ERROR_OPEN_GAUGE_METRIC, () -> this.openPermanentErrorCount).description("Open permanent errors").register(this.meterRegistry);
        Gauge.builder((String)PENDING_MANUALTASK_CREATE_ERRORS_GAUGE_METRIC, () -> this.pendingManualTaskCreationErrorCount).description("Permanent errors with pending manual task creation").register(this.meterRegistry);
        Gauge.builder((String)PENDING_MANUALTASK_RESOLVE_ERRORS_GAUGE_METRIC, () -> this.resolveOnManualTaskErrorCount).description("Permanent errors with pending manual task resolution").register(this.meterRegistry);
        Gauge.builder((String)PENDING_MANUALTASK_DELETE_ERRORS_GAUGE_METRIC, () -> this.deleteOnManualTaskErrorCount).description("Permanent errors with pending manual task deletion").register(this.meterRegistry);
        Gauge.builder((String)ERROR_GROUPS_WITH_OPEN_ERRORS_GAUGE_METRIC, () -> this.errorGroupsWithOpenErrors).description("Error groups with open errors").register(this.meterRegistry);
        this.createdTemporaryErrors = Counter.builder((String)CREATED_TEMPORARY_ERRORS_COUNTER_METRIC).description("Created temporary errors").register(this.meterRegistry);
    }

    @Scheduled(fixedRateString="${jeap.errorhandling.metrics.updateFrequencyMillis}")
    void updateGauges() {
        this.temporaryRetryPendingErrorCount = this.errorRepository.countErrorsInStateTemporaryRetryPending();
        this.openPermanentErrorCount = this.errorRepository.countErrorsInStatesPermanentOrSendToManualTask();
        this.pendingManualTaskCreationErrorCount = this.errorRepository.countErrorsInStateSendToManualTask();
        this.resolveOnManualTaskErrorCount = this.errorRepository.countErrorsInStateResolveOnManualTask();
        this.deleteOnManualTaskErrorCount = this.errorRepository.countErrorsInStateDeleteOnManualTask();
        this.errorGroupsWithOpenErrors = this.errorGroupRepository.countErrorGroupsWithErrorsInStates(OPEN_ERROR_STATES);
    }

    public void incrementPermanentCounter(String causingService) {
        Counter.builder((String)CREATED_PERMANENT_ERRORS_COUNTER_METRIC).description("Created permanent errors").tag(CAUSING_SERVICE_TAG, causingService).register(this.meterRegistry).increment();
    }

    public void incrementTemporaryCounter() {
        this.createdTemporaryErrors.increment();
    }

    @Generated
    public ErrorHandlingMetricsService(MeterRegistry meterRegistry, ErrorRepository errorRepository, ErrorGroupRepository errorGroupRepository) {
        this.meterRegistry = meterRegistry;
        this.errorRepository = errorRepository;
        this.errorGroupRepository = errorGroupRepository;
    }
}

