/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.jira;

import ch.admin.bit.jeap.errorhandling.infrastructure.jira.JiraCommunicationException;
import ch.admin.bit.jeap.errorhandling.infrastructure.jira.JiraConfigurationProperties;
import ch.admin.bit.jeap.errorhandling.infrastructure.jira.JiraCreateIssueRequest;
import ch.admin.bit.jeap.errorhandling.infrastructure.jira.JiraCreateIssueResponse;
import ch.admin.bit.jeap.errorhandling.infrastructure.jira.JiraResponseException;
import ch.admin.bit.jeap.errorhandling.infrastructure.jira.JiraRestClient;
import ch.admin.bit.jeap.errorhandling.infrastructure.jira.JiraUnexpectedResponseException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.support.RestClientAdapter;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpServiceProxyFactory;

public class JiraClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JiraClient.class);
    private final JiraConfigurationProperties jiraConfigurationProperties;
    private final JiraRestClient jiraRestClient;

    public JiraClient(JiraConfigurationProperties jiraConfigurationProperties, RestClient.Builder restClientBuilder) {
        this.jiraConfigurationProperties = jiraConfigurationProperties;
        ClientHttpRequestFactorySettings httpSettings = ClientHttpRequestFactorySettings.defaults().withConnectTimeout(Duration.ofMillis(jiraConfigurationProperties.getConnectTimeoutMs())).withReadTimeout(Duration.ofMillis(jiraConfigurationProperties.getReadTimeoutMs()));
        ClientHttpRequestFactory requestFactory = ClientHttpRequestFactoryBuilder.detect().build(httpSettings);
        String jiraBaseUrl = JiraClient.withoutTrailingSlash(jiraConfigurationProperties.getBaseUrl());
        log.info("Using Jira base URL: {}", (Object)jiraBaseUrl);
        RestClient restClient = restClientBuilder.clone().requestFactory(requestFactory).baseUrl(jiraBaseUrl).defaultHeaders(this::setAuth).build();
        HttpServiceProxyFactory proxyFactory = HttpServiceProxyFactory.builderFor((HttpExchangeAdapter)RestClientAdapter.create((RestClient)restClient)).build();
        this.jiraRestClient = (JiraRestClient)proxyFactory.createClient(JiraRestClient.class);
    }

    private void setAuth(HttpHeaders headers) {
        if (StringUtils.hasText((String)this.jiraConfigurationProperties.getToken())) {
            headers.setBearerAuth(this.jiraConfigurationProperties.getToken());
        } else {
            headers.setBasicAuth(this.jiraConfigurationProperties.getUsername(), this.jiraConfigurationProperties.getPassword(), StandardCharsets.UTF_8);
        }
    }

    public String createIssue(String projectKey, String issueType, String summary, String description, String reporterName) {
        JiraCreateIssueRequest payload = JiraCreateIssueRequest.from(projectKey, issueType, summary, description, reporterName);
        try {
            JiraCreateIssueResponse response = this.jiraRestClient.createIssue(payload);
            if (response == null || !StringUtils.hasText((String)response.key())) {
                throw new JiraUnexpectedResponseException("The response from Jira was empty or the issue key returned was empty.");
            }
            return response.key();
        }
        catch (RestClientResponseException ex) {
            throw new JiraResponseException(ex.getMessage(), ex.getStatusCode(), ex.getResponseBodyAsString(), ex);
        }
        catch (RestClientException ex) {
            throw new JiraCommunicationException(ex);
        }
    }

    private static String withoutTrailingSlash(String baseUrl) {
        if (!StringUtils.hasText((String)baseUrl)) {
            throw new IllegalArgumentException("Jira base URL must not be blank.");
        }
        return baseUrl.trim().replaceAll("/+$", "");
    }
}

