/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.group;

import ch.admin.bit.jeap.errorhandling.domain.exceptions.ErrorGroupAlreadyHasATicketNumberAssignedException;
import ch.admin.bit.jeap.errorhandling.domain.exceptions.ErrorGroupNotFoundException;
import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupAggregatedData;
import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupAggregatedDataList;
import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupConfigProperties;
import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupIssueTrackingProperties;
import ch.admin.bit.jeap.errorhandling.domain.group.IssueDescriptionGenerator;
import ch.admin.bit.jeap.errorhandling.domain.group.IssueSummaryGenerator;
import ch.admin.bit.jeap.errorhandling.domain.issue.IssueTracking;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorGroup;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorGroupRepository;
import ch.admin.bit.jeap.errorhandling.web.api.ErrorGroupSearchCriteria;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StringUtils;

@Service
@Transactional
public class ErrorGroupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorGroupService.class);
    public static final String A_LONG_LONG_TIME_AGO = "1971-03-11T00:00:00Z";
    public static final String FAR_FAR_IN_THE_FUTURE = "2999-12-31T00:00:00Z";
    private final ErrorGroupConfigProperties errorGroupConfigProperties;
    private final ErrorGroupRepository errorGroupRepository;
    private final PlatformTransactionManager transactionManager;
    private final IssueDescriptionGenerator issueDescriptionGenerator;
    private final IssueSummaryGenerator issueSummaryGenerator;
    private final Optional<IssueTracking> issueTracking;

    public ErrorGroup assignToErrorGroup(Error error) {
        if (this.errorGroupConfigProperties.isErrorGroupingEnabled() && StringUtils.hasText((String)error.getErrorEventData().getStackTraceHash())) {
            ErrorGroup errorGroup = this.findOrCreateMatchingErrorGroup(error);
            error.setErrorGroup(errorGroup);
            return errorGroup;
        }
        return null;
    }

    public ErrorGroup updateTicketNumber(UUID errorGroupId, String ticketNumber) {
        ErrorGroup errorGroup = this.findErrorGroup(errorGroupId);
        errorGroup.setTicketNumber(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ticketNumber) ? ticketNumber : null);
        return errorGroup;
    }

    public ErrorGroup updateFreeText(UUID errorGroupId, String freeText) {
        ErrorGroup errorGroup = this.findErrorGroup(errorGroupId);
        errorGroup.setFreeText(freeText);
        return errorGroup;
    }

    public ErrorGroupAggregatedData getErrorGroupAggregatedData(UUID errorGroupId) {
        return this.errorGroupRepository.findErrorGroupAggregatedData(errorGroupId).orElseThrow(() -> new ErrorGroupNotFoundException(errorGroupId));
    }

    public ErrorGroupAggregatedDataList findErrorGroupAggregatedData(ErrorGroupSearchCriteria criteria) {
        Boolean noTicket = criteria.getNoTicket().orElse(false);
        ZonedDateTime dateFrom = criteria.getDateFrom().orElse(ZonedDateTime.parse(A_LONG_LONG_TIME_AGO));
        ZonedDateTime dateTo = criteria.getDateTo().orElse(ZonedDateTime.parse(FAR_FAR_IN_THE_FUTURE));
        String source = criteria.getSource().orElse(null);
        String messageType = criteria.getMessageType().orElse(null);
        String errorCode = criteria.getErrorCode().orElse(null);
        String jiraTicket = criteria.getJiraTicket().orElse(null);
        Page<ErrorGroupAggregatedData> groupAggregatedData = this.errorGroupRepository.findErrorGroupAggregatedData(noTicket, dateFrom, dateTo, source, messageType, errorCode, jiraTicket, criteria.getPageable());
        return new ErrorGroupAggregatedDataList(groupAggregatedData.getTotalElements(), groupAggregatedData.getContent());
    }

    public String createIssue(UUID errorGroupId) {
        if (this.issueTracking.isEmpty()) {
            throw new IllegalStateException("Issue tracking is not configured.");
        }
        Optional<ErrorGroupAggregatedData> egDataOptional = this.errorGroupRepository.findErrorGroupAggregatedData(errorGroupId);
        if (egDataOptional.isEmpty()) {
            throw new ErrorGroupNotFoundException(errorGroupId);
        }
        ErrorGroupAggregatedData egData = egDataOptional.get();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)egData.getTicketNumber())) {
            throw new ErrorGroupAlreadyHasATicketNumberAssignedException(errorGroupId, egData.getTicketNumber());
        }
        ErrorGroupIssueTrackingProperties issueTrackingProperties = this.errorGroupConfigProperties.getIssueTracking();
        String description = this.issueDescriptionGenerator.generateDescription(egData);
        String summary = this.issueSummaryGenerator.generateIssueSummary(egData);
        String issueId = this.issueTracking.get().createIssue(issueTrackingProperties.getIssueType(), issueTrackingProperties.getProject(), summary, description);
        this.updateTicketNumber(errorGroupId, issueId);
        return issueId;
    }

    private ErrorGroup findOrCreateMatchingErrorGroup(Error error) {
        ErrorGroup errorGroup = ErrorGroup.from(error);
        try {
            return this.saveOrGetErrorGroup(errorGroup);
        }
        catch (TransactionException e) {
            if (e.contains(DataIntegrityViolationException.class)) {
                return this.saveOrGetErrorGroup(errorGroup);
            }
            throw e;
        }
    }

    private ErrorGroup saveOrGetErrorGroup(ErrorGroup errorGroup) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        return (ErrorGroup)transactionTemplate.execute(status -> {
            Optional<ErrorGroup> existingErrorGroup = this.findMatchingErrorGroup(errorGroup);
            if (existingErrorGroup.isEmpty()) {
                log.debug("Creating new error group: {}.", (Object)errorGroup);
                return (ErrorGroup)this.errorGroupRepository.save(errorGroup);
            }
            log.debug("Found existing error group: {}.", (Object)existingErrorGroup.get());
            return existingErrorGroup.get();
        });
    }

    private ErrorGroup findErrorGroup(UUID errorGroupId) {
        return (ErrorGroup)this.errorGroupRepository.findById(errorGroupId).orElseThrow(() -> new ErrorGroupNotFoundException(errorGroupId));
    }

    private Optional<ErrorGroup> findMatchingErrorGroup(ErrorGroup errorGroup) {
        return this.errorGroupRepository.findByErrorPublisherAndErrorCodeAndEventNameAndErrorStackTraceHash(errorGroup.getErrorPublisher(), errorGroup.getErrorCode(), errorGroup.getEventName(), errorGroup.getErrorStackTraceHash());
    }

    @Generated
    public ErrorGroupService(ErrorGroupConfigProperties errorGroupConfigProperties, ErrorGroupRepository errorGroupRepository, PlatformTransactionManager transactionManager, IssueDescriptionGenerator issueDescriptionGenerator, IssueSummaryGenerator issueSummaryGenerator, Optional<IssueTracking> issueTracking) {
        this.errorGroupConfigProperties = errorGroupConfigProperties;
        this.errorGroupRepository = errorGroupRepository;
        this.transactionManager = transactionManager;
        this.issueDescriptionGenerator = issueDescriptionGenerator;
        this.issueSummaryGenerator = issueSummaryGenerator;
        this.issueTracking = issueTracking;
    }
}

