/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.jira;

import ch.admin.bit.jeap.errorhandling.domain.exceptions.IssueTrackingBadRequest;
import ch.admin.bit.jeap.errorhandling.domain.exceptions.IssueTrackingCommunicationError;
import ch.admin.bit.jeap.errorhandling.domain.exceptions.IssueTrackingServerError;
import ch.admin.bit.jeap.errorhandling.domain.issue.IssueTracking;
import ch.admin.bit.jeap.errorhandling.infrastructure.jira.JiraClient;
import ch.admin.bit.jeap.errorhandling.infrastructure.jira.JiraCommunicationException;
import ch.admin.bit.jeap.errorhandling.infrastructure.jira.JiraConfigurationProperties;
import ch.admin.bit.jeap.errorhandling.infrastructure.jira.JiraUnexpectedResponseException;
import lombok.Generated;
import org.springframework.web.client.RestClientResponseException;

public class JiraIssueTracking
implements IssueTracking {
    private final JiraConfigurationProperties jiraConfigurationProperties;
    private final JiraClient jiraClient;

    @Override
    public String createIssue(String type, String project, String summary, String description) {
        try {
            return this.jiraClient.createIssue(project, type, summary, description, this.jiraConfigurationProperties.getUsername());
        }
        catch (RestClientResponseException rcre) {
            if (rcre.getStatusCode().is4xxClientError()) {
                throw new IssueTrackingBadRequest("Bad 'create issue request' reported by Jira.", rcre);
            }
            if (rcre.getStatusCode().is5xxServerError()) {
                throw new IssueTrackingServerError("Server error from Jira.", rcre);
            }
            throw rcre;
        }
        catch (JiraUnexpectedResponseException jure) {
            throw new IssueTrackingServerError("Unexpected response from Jira.", jure);
        }
        catch (JiraCommunicationException jce) {
            throw new IssueTrackingCommunicationError("Communication error with Jira.", jce);
        }
    }

    @Generated
    public JiraIssueTracking(JiraConfigurationProperties jiraConfigurationProperties, JiraClient jiraClient) {
        this.jiraConfigurationProperties = jiraConfigurationProperties;
        this.jiraClient = jiraClient;
    }
}

