/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.web.api;

import ch.admin.bit.jeap.errorhandling.domain.exceptions.InvalidUuidException;
import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupAggregatedData;
import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupAggregatedDataList;
import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupService;
import ch.admin.bit.jeap.errorhandling.web.api.DateTimeUtils;
import ch.admin.bit.jeap.errorhandling.web.api.ErrorGroupDTO;
import ch.admin.bit.jeap.errorhandling.web.api.ErrorGroupResponse;
import ch.admin.bit.jeap.errorhandling.web.api.ErrorGroupSearchCriteria;
import ch.admin.bit.jeap.errorhandling.web.api.ErrorGroupSearchFormDto;
import ch.admin.bit.jeap.errorhandling.web.api.UpdateFreeTextRequest;
import ch.admin.bit.jeap.errorhandling.web.api.UpdateTicketNumberRequest;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="ErrorGroup")
@RestController
@RequestMapping(value={"/api/error-group"})
public class ErrorGroupController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorGroupController.class);
    private final ErrorGroupService errorGroupService;

    @PostMapping
    @PreAuthorize(value="hasRole('errorgroup','view')")
    public ErrorGroupResponse getGroups(@RequestParam(name="pageIndex", required=false, defaultValue="0") int pageIndex, @RequestParam(name="pageSize", required=false, defaultValue="10") int pageSize, @RequestBody(required=false) ErrorGroupSearchFormDto errorGroupSearchFormDto) {
        if (errorGroupSearchFormDto == null) {
            errorGroupSearchFormDto = new ErrorGroupSearchFormDto();
        }
        ErrorGroupSearchCriteria errorGroupSearchCriteria = ErrorGroupSearchCriteria.builder().dateFrom(DateTimeUtils.parseDate(errorGroupSearchFormDto.getDateFrom())).dateTo(DateTimeUtils.parseDate(errorGroupSearchFormDto.getDateTo())).noTicket(errorGroupSearchFormDto.getNoTicket()).source(errorGroupSearchFormDto.getSource()).messageType(errorGroupSearchFormDto.getMessageType()).errorCode(errorGroupSearchFormDto.getErrorCode()).jiraTicket(errorGroupSearchFormDto.getJiraTicket()).pageIndex(pageIndex).pageSize(pageSize).build();
        ErrorGroupAggregatedDataList errorGroups = this.errorGroupService.findErrorGroupAggregatedData(errorGroupSearchCriteria);
        List<ErrorGroupDTO> errorGroupDTOS = errorGroups.groups().stream().map(this::mapToDTO).toList();
        return new ErrorGroupResponse(errorGroups.totalElements(), errorGroupDTOS);
    }

    @GetMapping(value={"/{errorGroupId}"})
    @PreAuthorize(value="hasRole('errorgroup','view')")
    public ResponseEntity<ErrorGroupDTO> getErrorGroupById(@PathVariable String errorGroupId) {
        UUID uuid;
        try {
            uuid = UUID.fromString(errorGroupId);
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.badRequest().body(null);
        }
        ErrorGroupAggregatedData data = this.errorGroupService.getErrorGroupAggregatedData(uuid);
        if (data == null) {
            return ResponseEntity.notFound().build();
        }
        ErrorGroupDTO dto = this.mapToDTO(data);
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping(value={"/update-ticket-number"})
    @PreAuthorize(value="hasRole('errorgroup','edit')")
    public ResponseEntity<ErrorGroupDTO> updateTicketNumber(@RequestBody @Valid UpdateTicketNumberRequest ticketNumberRequest) {
        UUID groupId = this.parseGroupId(ticketNumberRequest.getErrorGroupId());
        this.errorGroupService.updateTicketNumber(groupId, ticketNumberRequest.getTicketNumber());
        ErrorGroupDTO errorGroupDTO = this.getErrorGroupDTO(groupId);
        return ResponseEntity.ok((Object)errorGroupDTO);
    }

    @PostMapping(value={"/{groupId}/issue"})
    @PreAuthorize(value="hasRole('errorgroup','edit')")
    public ResponseEntity<ErrorGroupDTO> createIssue(@PathVariable(name="groupId") UUID groupId) {
        try {
            this.errorGroupService.createIssue(groupId);
        }
        catch (Throwable t) {
            log.error("Issue creation failed: '{}'", (Object)t.getMessage(), (Object)t);
            throw t;
        }
        ErrorGroupDTO errorGroupDTO = this.getErrorGroupDTO(groupId);
        return ResponseEntity.ok((Object)errorGroupDTO);
    }

    @PostMapping(value={"/update-free-text"})
    @PreAuthorize(value="hasRole('errorgroup','edit')")
    public ResponseEntity<ErrorGroupDTO> updateFreeText(@RequestBody @Valid UpdateFreeTextRequest freeTextRequest) {
        UUID groupId = this.parseGroupId(freeTextRequest.getErrorGroupId());
        this.errorGroupService.updateFreeText(groupId, freeTextRequest.getFreeText());
        ErrorGroupDTO errorGroupDTO = this.getErrorGroupDTO(groupId);
        return ResponseEntity.ok((Object)errorGroupDTO);
    }

    private ErrorGroupDTO getErrorGroupDTO(UUID groupId) {
        ErrorGroupAggregatedData errorGroupAggregatedData = this.errorGroupService.getErrorGroupAggregatedData(groupId);
        return this.mapToDTO(errorGroupAggregatedData);
    }

    private UUID parseGroupId(String groupIdString) {
        try {
            return UUID.fromString(groupIdString);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidUuidException(groupIdString);
        }
    }

    private ErrorGroupDTO mapToDTO(ErrorGroupAggregatedData groupAggregatedData) {
        return new ErrorGroupDTO(groupAggregatedData.getGroupId().toString(), groupAggregatedData.getErrorCount(), groupAggregatedData.getErrorEvent(), groupAggregatedData.getErrorPublisher(), groupAggregatedData.getErrorCode(), groupAggregatedData.getErrorMessage(), DateTimeUtils.timestamp(groupAggregatedData.getFirstErrorAt()), DateTimeUtils.timestamp(groupAggregatedData.getLatestErrorAt()), groupAggregatedData.getTicketNumber(), groupAggregatedData.getFreeText(), groupAggregatedData.getStackTraceHash());
    }

    @Generated
    public ErrorGroupController(ErrorGroupService errorGroupService) {
        this.errorGroupService = errorGroupService;
    }
}

