/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.manualtask.taskFactory;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

@Configuration
@ConfigurationProperties(prefix="jeap.errorhandling.task-management.default-factory")
@Validated
public class DefaultTaskFactoryProperties {
    public static final String PREFIX = "jeap.errorhandling.task-management.default-factory";
    private String errorServiceBaseUrl;
    private String system;
    private String priority = "HIGH";
    private Duration timeToHandle = Duration.of(1L, ChronoUnit.DAYS);
    private String taskReferenceName = "Error Service";
    private String domain = "error-handling";
    @NotEmpty
    private Map<String, TaskDisplayProperties> display = DefaultTaskFactoryProperties.defaultDisplay();

    public void validate() {
        Objects.requireNonNull(this.system, "jeap.errorhandling.task-management.default-factory.system is not configured");
        Objects.requireNonNull(this.errorServiceBaseUrl, "jeap.errorhandling.task-management.default-factory.errorServiceBaseUrl is not configured");
    }

    private static Map<String, TaskDisplayProperties> defaultDisplay() {
        return Map.of("DE", TaskDisplayProperties.builder().title("Fehlgeschlagene Nachrichten-Verarbeitung").description("Ein technischer Fehler ist aufgrund einer unverarbeitbaren Nachricht aufgetreten.").displayName("Nachrichten-Verarbeitungsfehler").displayDomain("Error Handling").build(), "FR", TaskDisplayProperties.builder().title("Erreur du traitement des messages").description("Une erreur technique s'est produite en raison d'un message qui ne peut \u00eatre trait\u00e9.").displayName("Erreur de traitement des messages").displayDomain("Error Handling").build(), "IT", TaskDisplayProperties.builder().title("Errore durante l'elaborazione di un messaggio").description("Si \u00e8 prodotto un errore tecnico a causa di un messaggio non processabile.").displayName("Errore durante l'elaborazione di un messaggio").displayDomain("Error Handling").build(), "EN", TaskDisplayProperties.builder().title("Message processing failure").description("A technical error has occurred due to an unprocessable message.").displayName("Message processing error").displayDomain("Error Handling").build());
    }

    @Generated
    public DefaultTaskFactoryProperties() {
    }

    @Generated
    public String getErrorServiceBaseUrl() {
        return this.errorServiceBaseUrl;
    }

    @Generated
    public String getSystem() {
        return this.system;
    }

    @Generated
    public String getPriority() {
        return this.priority;
    }

    @Generated
    public Duration getTimeToHandle() {
        return this.timeToHandle;
    }

    @Generated
    public String getTaskReferenceName() {
        return this.taskReferenceName;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public Map<String, TaskDisplayProperties> getDisplay() {
        return this.display;
    }

    @Generated
    public void setErrorServiceBaseUrl(String errorServiceBaseUrl) {
        this.errorServiceBaseUrl = errorServiceBaseUrl;
    }

    @Generated
    public void setSystem(String system) {
        this.system = system;
    }

    @Generated
    public void setPriority(String priority) {
        this.priority = priority;
    }

    @Generated
    public void setTimeToHandle(Duration timeToHandle) {
        this.timeToHandle = timeToHandle;
    }

    @Generated
    public void setTaskReferenceName(String taskReferenceName) {
        this.taskReferenceName = taskReferenceName;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setDisplay(Map<String, TaskDisplayProperties> display) {
        this.display = display;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultTaskFactoryProperties)) {
            return false;
        }
        DefaultTaskFactoryProperties other = (DefaultTaskFactoryProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$errorServiceBaseUrl = this.getErrorServiceBaseUrl();
        String other$errorServiceBaseUrl = other.getErrorServiceBaseUrl();
        if (this$errorServiceBaseUrl == null ? other$errorServiceBaseUrl != null : !this$errorServiceBaseUrl.equals(other$errorServiceBaseUrl)) {
            return false;
        }
        String this$system = this.getSystem();
        String other$system = other.getSystem();
        if (this$system == null ? other$system != null : !this$system.equals(other$system)) {
            return false;
        }
        String this$priority = this.getPriority();
        String other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !this$priority.equals(other$priority)) {
            return false;
        }
        Duration this$timeToHandle = this.getTimeToHandle();
        Duration other$timeToHandle = other.getTimeToHandle();
        if (this$timeToHandle == null ? other$timeToHandle != null : !((Object)this$timeToHandle).equals(other$timeToHandle)) {
            return false;
        }
        String this$taskReferenceName = this.getTaskReferenceName();
        String other$taskReferenceName = other.getTaskReferenceName();
        if (this$taskReferenceName == null ? other$taskReferenceName != null : !this$taskReferenceName.equals(other$taskReferenceName)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        Map<String, TaskDisplayProperties> this$display = this.getDisplay();
        Map<String, TaskDisplayProperties> other$display = other.getDisplay();
        return !(this$display == null ? other$display != null : !((Object)this$display).equals(other$display));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultTaskFactoryProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $errorServiceBaseUrl = this.getErrorServiceBaseUrl();
        result = result * 59 + ($errorServiceBaseUrl == null ? 43 : $errorServiceBaseUrl.hashCode());
        String $system = this.getSystem();
        result = result * 59 + ($system == null ? 43 : $system.hashCode());
        String $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : $priority.hashCode());
        Duration $timeToHandle = this.getTimeToHandle();
        result = result * 59 + ($timeToHandle == null ? 43 : ((Object)$timeToHandle).hashCode());
        String $taskReferenceName = this.getTaskReferenceName();
        result = result * 59 + ($taskReferenceName == null ? 43 : $taskReferenceName.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        Map<String, TaskDisplayProperties> $display = this.getDisplay();
        result = result * 59 + ($display == null ? 43 : ((Object)$display).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultTaskFactoryProperties(errorServiceBaseUrl=" + this.getErrorServiceBaseUrl() + ", system=" + this.getSystem() + ", priority=" + this.getPriority() + ", timeToHandle=" + String.valueOf(this.getTimeToHandle()) + ", taskReferenceName=" + this.getTaskReferenceName() + ", domain=" + this.getDomain() + ", display=" + String.valueOf(this.getDisplay()) + ")";
    }

    static class TaskDisplayProperties {
        @NotBlank
        private String displayName;
        @NotBlank
        private String displayDomain;
        @NotBlank
        private String title;
        @NotBlank
        private String description;

        @Generated
        public static TaskDisplayPropertiesBuilder builder() {
            return new TaskDisplayPropertiesBuilder();
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getDisplayDomain() {
            return this.displayDomain;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Generated
        public void setDisplayDomain(String displayDomain) {
            this.displayDomain = displayDomain;
        }

        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskDisplayProperties)) {
                return false;
            }
            TaskDisplayProperties other = (TaskDisplayProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$displayDomain = this.getDisplayDomain();
            String other$displayDomain = other.getDisplayDomain();
            if (this$displayDomain == null ? other$displayDomain != null : !this$displayDomain.equals(other$displayDomain)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaskDisplayProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $displayDomain = this.getDisplayDomain();
            result = result * 59 + ($displayDomain == null ? 43 : $displayDomain.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultTaskFactoryProperties.TaskDisplayProperties(displayName=" + this.getDisplayName() + ", displayDomain=" + this.getDisplayDomain() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public TaskDisplayProperties() {
        }

        @Generated
        public TaskDisplayProperties(String displayName, String displayDomain, String title, String description) {
            this.displayName = displayName;
            this.displayDomain = displayDomain;
            this.title = title;
            this.description = description;
        }

        @Generated
        public static class TaskDisplayPropertiesBuilder {
            @Generated
            private String displayName;
            @Generated
            private String displayDomain;
            @Generated
            private String title;
            @Generated
            private String description;

            @Generated
            TaskDisplayPropertiesBuilder() {
            }

            @Generated
            public TaskDisplayPropertiesBuilder displayName(String displayName) {
                this.displayName = displayName;
                return this;
            }

            @Generated
            public TaskDisplayPropertiesBuilder displayDomain(String displayDomain) {
                this.displayDomain = displayDomain;
                return this;
            }

            @Generated
            public TaskDisplayPropertiesBuilder title(String title) {
                this.title = title;
                return this;
            }

            @Generated
            public TaskDisplayPropertiesBuilder description(String description) {
                this.description = description;
                return this;
            }

            @Generated
            public TaskDisplayProperties build() {
                return new TaskDisplayProperties(this.displayName, this.displayDomain, this.title, this.description);
            }

            @Generated
            public String toString() {
                return "DefaultTaskFactoryProperties.TaskDisplayProperties.TaskDisplayPropertiesBuilder(displayName=" + this.displayName + ", displayDomain=" + this.displayDomain + ", title=" + this.title + ", description=" + this.description + ")";
            }
        }
    }
}

