/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.resend.scheduler;

import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ScheduledResend;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ScheduledResendRepository;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class ScheduledResendService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScheduledResendService.class);
    final ScheduledResendRepository scheduledResendRepository;

    public void scheduleResend(UUID errorId, ZonedDateTime resendAt) {
        ScheduledResend scheduledResend = new ScheduledResend(errorId, resendAt);
        log.debug("Create scheduled resend {}.", (Object)scheduledResend);
        this.scheduledResendRepository.save(scheduledResend);
    }

    @Transactional(readOnly=true)
    public ZonedDateTime getNextResendTimestamp(UUID errrorId) {
        Optional<ScheduledResend> nextResend = this.scheduledResendRepository.findNextScheduledResend(errrorId);
        return nextResend.map(ScheduledResend::getResendAt).orElse(null);
    }

    public void cancelScheduledResends(Error error) {
        if (error.getState() == Error.ErrorState.TEMPORARY_RETRY_PENDING) {
            List<ScheduledResend> scheduledResends = this.scheduledResendRepository.findByErrorId(error.getId());
            log.info("Cancelling {} scheduled resends for error {}", (Object)scheduledResends.size(), (Object)error.getId());
            scheduledResends.forEach(ScheduledResend::cancel);
        }
    }

    public void setResent(ScheduledResend scheduledResend) {
        log.debug("Setting resentAt for {} to now.", (Object)scheduledResend.getId());
        scheduledResend.setResentAt(ZonedDateTime.now());
        this.scheduledResendRepository.save(scheduledResend);
    }

    @Generated
    public ScheduledResendService(ScheduledResendRepository scheduledResendRepository) {
        this.scheduledResendRepository = scheduledResendRepository;
    }
}

