/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.persistence;

import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Version;
import java.time.ZonedDateTime;
import java.util.UUID;
import lombok.Generated;

@Entity
public class ScheduledResend {
    @Id
    private UUID id = UUID.randomUUID();
    private ZonedDateTime resendAt;
    private UUID errorId;
    private boolean cancelled;
    private ZonedDateTime resentAt;
    @Version
    private int version;

    public ScheduledResend(UUID errorId, ZonedDateTime resendAt) {
        if (errorId == null) {
            throw new IllegalArgumentException("errorId must be provided");
        }
        if (resendAt == null) {
            throw new IllegalArgumentException("resendAt must be provided");
        }
        this.errorId = errorId;
        this.resendAt = resendAt;
    }

    public void cancel() {
        this.cancelled = true;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public ZonedDateTime getResendAt() {
        return this.resendAt;
    }

    @Generated
    public UUID getErrorId() {
        return this.errorId;
    }

    @Generated
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Generated
    public ZonedDateTime getResentAt() {
        return this.resentAt;
    }

    @Generated
    public int getVersion() {
        return this.version;
    }

    @Generated
    public ScheduledResend() {
    }

    @Generated
    public String toString() {
        return "ScheduledResend(id=" + String.valueOf(this.getId()) + ", resendAt=" + String.valueOf(this.getResendAt()) + ", errorId=" + String.valueOf(this.getErrorId()) + ", cancelled=" + this.isCancelled() + ", resentAt=" + String.valueOf(this.getResentAt()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public void setResentAt(ZonedDateTime resentAt) {
        this.resentAt = resentAt;
    }
}

