/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.group;

import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupAggregatedData;
import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupConfigProperties;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Map;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.util.PropertyPlaceholderHelper;

@Component
public class IssueDescriptionGenerator {
    static final String GROUP_URL_ID_PLACEHOLDER = "{groupId}";
    private static final String DESCRIPTION_TEMPLATE = "The error handling service detected a group of errors:\n   ||_Error Group Property_         ||_Data_ ||\n   |\u00a0 Error Group Id         \u00a0|\u00a0 *[${group-id}|${group-url}]* \u00a0|\n   |\u00a0 Error Source           \u00a0|\u00a0 *${source}* \u00a0|\n   |\u00a0 Error Message Type     \u00a0|\u00a0 *${message-type}* \u00a0|\n   |\u00a0 Error Code             \u00a0|\u00a0 *${code}* \u00a0|\n   |\u00a0 Error Message          \u00a0|\u00a0 *${message}* \u00a0|\n   |\u00a0 Error Group Created At \u00a0|\u00a0 *${group-created-at}* \u00a0|\n";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG);
    private final ErrorGroupConfigProperties ehgConfigProperties;
    private final PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("${", "}", null, null, false);

    public String generateDescription(ErrorGroupAggregatedData egData) {
        String formattedGroupCreatedDateTime = DATE_TIME_FORMATTER.format(egData.getGroupCreatedAt());
        String groupIdString = egData.getGroupId().toString();
        String groupUrl = this.ehgConfigProperties.getIssueTracking().getErrorHandlingServiceGroupUrlTemplate().replace(GROUP_URL_ID_PLACEHOLDER, groupIdString);
        Map<String, String> descriptionData = Map.of("group-id", groupIdString, "source", egData.getErrorPublisher(), "message-type", egData.getErrorEvent(), "code", egData.getErrorCode(), "message", egData.getErrorMessage(), "group-created-at", formattedGroupCreatedDateTime, "group-url", groupUrl);
        return this.placeholderHelper.replacePlaceholders(DESCRIPTION_TEMPLATE, descriptionData::get);
    }

    @Generated
    public IssueDescriptionGenerator(ErrorGroupConfigProperties ehgConfigProperties) {
        this.ehgConfigProperties = ehgConfigProperties;
    }
}

