/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.resend.scheduler;

import ch.admin.bit.jeap.errorhandling.domain.error.ErrorService;
import ch.admin.bit.jeap.errorhandling.domain.resend.scheduler.ResendSchedulerConfigProperties;
import ch.admin.bit.jeap.errorhandling.domain.resend.scheduler.ScheduledResendService;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ScheduledResend;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ScheduledResendRepository;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;
import net.javacrumbs.shedlock.core.LockAssert;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;

@Component
class ResendScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResendScheduler.class);
    final ScheduledResendRepository scheduledResendRepository;
    final ResendSchedulerConfigProperties resendSchedulerConfigProperties;
    final ScheduledResendService scheduledResendService;
    final ErrorService errorService;
    final PlatformTransactionManager platformTransactionManager;

    @Scheduled(cron="#{@resendSchedulerConfigProperties.cronExpression}")
    @SchedulerLock(name="execute-pending-schedules", lockAtLeastFor="#{@resendSchedulerConfigProperties.lockAtLeast.toString()}", lockAtMostFor="#{@resendSchedulerConfigProperties.lockAtMost.toString()}")
    public void executePendingSchedules() {
        LockAssert.assertLocked();
        for (int processedChunks = 0; processedChunks < this.resendSchedulerConfigProperties.getMaxConsecutiveChunks(); ++processedChunks) {
            log.trace("Fetching at max {} unsent scheduled resend items ready to be sent now.", (Object)this.resendSchedulerConfigProperties.getMaxResendChunkSize());
            List<ScheduledResend> chunk = this.scheduledResendRepository.findNextScheduledResendsOldestFirst(ZonedDateTime.now(), this.resendSchedulerConfigProperties.getMaxResendChunkSize());
            if (chunk.isEmpty()) {
                log.trace("No unsent scheduled resend items found. Waiting for next execution...");
                return;
            }
            log.debug("Got {} unsent scheduled resend items in chunk #{}.", (Object)chunk.size(), (Object)processedChunks);
            chunk.forEach(this.errorService::scheduledResend);
        }
        log.debug("Maximum number of consecutive chunks reached. Proceeding at next execution...");
    }

    @Generated
    public ResendScheduler(ScheduledResendRepository scheduledResendRepository, ResendSchedulerConfigProperties resendSchedulerConfigProperties, ScheduledResendService scheduledResendService, ErrorService errorService, PlatformTransactionManager platformTransactionManager) {
        this.scheduledResendRepository = scheduledResendRepository;
        this.resendSchedulerConfigProperties = resendSchedulerConfigProperties;
        this.scheduledResendService = scheduledResendService;
        this.errorService = errorService;
        this.platformTransactionManager = platformTransactionManager;
    }
}

