/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.group;

import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupAggregatedData;
import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupConfigProperties;
import jakarta.annotation.PostConstruct;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Map;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.util.PropertyPlaceholderHelper;

@Component
public class IssueSummaryGenerator {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT);
    private final ErrorGroupConfigProperties ehgConfigProperties;
    private final PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("{", "}", null, null, false);

    public String generateIssueSummary(ErrorGroupAggregatedData egData) {
        return this.generateIssueSummary(egData.getGroupId().toString(), egData.getGroupCreatedAt(), egData.getErrorPublisher(), egData.getErrorEvent(), egData.getErrorCode(), egData.getErrorCount());
    }

    String generateIssueSummary(String groupId, ZonedDateTime groupCreatedDatetime, String source, String messageType, String errorCode, long errorCount) {
        String formattedGroupCreatedDateTime = DATE_TIME_FORMATTER.format(groupCreatedDatetime);
        Map<String, String> parameters = Map.of(IssueSummaryParameters.GROUP_ID.parameterName(), groupId, IssueSummaryParameters.GROUP_CREATED_DATETIME.parameterName(), formattedGroupCreatedDateTime, IssueSummaryParameters.SOURCE.parameterName(), source, IssueSummaryParameters.MESSAGE_TYPE.parameterName(), messageType, IssueSummaryParameters.ERROR_CODE.parameterName(), errorCode, IssueSummaryParameters.ERROR_COUNT.parameterName(), Long.toString(errorCount));
        return this.placeholderHelper.replacePlaceholders(this.ehgConfigProperties.getIssueTracking().getIssueSummaryTemplate(), parameters::get);
    }

    @PostConstruct
    void validateConfiguration() {
        if (this.ehgConfigProperties.getIssueTracking() != null) {
            try {
                this.generateIssueSummary("groupId", ZonedDateTime.now(), "source", "messageType", "errorCode", 1L);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Issue summary template is invalid: " + this.ehgConfigProperties.getIssueTracking().getIssueSummaryTemplate(), e);
            }
        }
    }

    @Generated
    public IssueSummaryGenerator(ErrorGroupConfigProperties ehgConfigProperties) {
        this.ehgConfigProperties = ehgConfigProperties;
    }

    public static enum IssueSummaryParameters {
        GROUP_ID("group-id"),
        GROUP_CREATED_DATETIME("group-created-datetime"),
        SOURCE("source"),
        MESSAGE_TYPE("message-type"),
        ERROR_CODE("error-code"),
        ERROR_COUNT("error-count");

        private final String parameterName;

        private IssueSummaryParameters(String parameterName) {
            this.parameterName = parameterName;
        }

        public String parameterName() {
            return this.parameterName;
        }
    }
}

