/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.kafka;

import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.KafkaErrorHandlingConfigProperties;
import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.RecoverableEhsProcessingException;
import ch.admin.bit.jeap.messaging.kafka.errorhandling.ErrorServiceSender;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ConsumerRecordRecoverer;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

@AutoConfiguration
@EnableConfigurationProperties(value={KafkaErrorHandlingConfigProperties.class})
public class KafkaErrorHandlingConfiguration {
    public static final String BACKOFF_BEAN_NAME = "ehsKafkaErrorHandlingBackOff";

    @Bean
    CommonErrorHandler errorHandler(ErrorServiceSender errorServiceSender, @Qualifier(value="ehsKafkaErrorHandlingBackOff") BackOff backOff) {
        DefaultErrorHandler errorHandler = new DefaultErrorHandler((ConsumerRecordRecoverer)errorServiceSender, backOff);
        errorHandler.defaultFalse();
        errorHandler.addRetryableExceptions(new Class[]{RecoverableEhsProcessingException.class});
        return errorHandler;
    }

    @Bean(name={"ehsKafkaErrorHandlingBackOff"})
    @ConditionalOnMissingBean(name={"ehsKafkaErrorHandlingBackOff"})
    BackOff ehsKafkaErrorHandlingBackOff(KafkaErrorHandlingConfigProperties kafkaErrorHandlingConfigProperties) {
        return new FixedBackOff(kafkaErrorHandlingConfigProperties.getRetryInterval().toMillis(), Long.MAX_VALUE);
    }
}

