/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.persistence;

import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.CausingEvent;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorEventData;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorGroup;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.EventMessage;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.EventMetadata;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.OriginalTraceContext;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Version;
import java.time.ZonedDateTime;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
public class Error {
    @Id
    @NonNull
    private UUID id;
    @Enumerated(value=EnumType.STRING)
    @NonNull
    private ErrorState state;
    @Embedded
    @NonNull
    private ErrorEventData errorEventData;
    @Embedded
    @NonNull
    private EventMetadata errorEventMetadata;
    @ManyToOne
    @NonNull
    private CausingEvent causingEvent;
    @NonNull
    private ZonedDateTime created;
    private ZonedDateTime modified;
    @Version
    private int version;
    private UUID manualTaskId;
    @Embedded
    private OriginalTraceContext originalTraceContext;
    private String closingReason;
    @ManyToOne(fetch=FetchType.LAZY)
    private ErrorGroup errorGroup;

    public void setErrorGroup(ErrorGroup errorGroup) {
        this.errorGroup = errorGroup;
        this.modifiedNow();
    }

    public void setState(ErrorState state) {
        this.state = state;
        this.modifiedNow();
    }

    public void setManualTaskId(UUID manualTaskId) {
        this.manualTaskId = manualTaskId;
        this.modifiedNow();
    }

    public void setClosingReason(String reason) {
        this.closingReason = reason;
        this.modifiedNow();
    }

    private void modifiedNow() {
        this.modified = ZonedDateTime.now();
    }

    public EventMessage getCausingEventMessage() {
        return this.causingEvent.getMessage();
    }

    public EventMetadata getCausingEventMetadata() {
        return this.causingEvent.getMetadata();
    }

    @Generated
    private static UUID $default$id() {
        return UUID.randomUUID();
    }

    @Generated
    public static ErrorBuilder builder() {
        return new ErrorBuilder();
    }

    @Generated
    public ErrorBuilder toBuilder() {
        return new ErrorBuilder().id(this.id).state(this.state).errorEventData(this.errorEventData).errorEventMetadata(this.errorEventMetadata).causingEvent(this.causingEvent).created(this.created).modified(this.modified).version(this.version).manualTaskId(this.manualTaskId).originalTraceContext(this.originalTraceContext).closingReason(this.closingReason).errorGroup(this.errorGroup);
    }

    @NonNull
    @Generated
    public UUID getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public ErrorState getState() {
        return this.state;
    }

    @NonNull
    @Generated
    public ErrorEventData getErrorEventData() {
        return this.errorEventData;
    }

    @NonNull
    @Generated
    public EventMetadata getErrorEventMetadata() {
        return this.errorEventMetadata;
    }

    @NonNull
    @Generated
    public CausingEvent getCausingEvent() {
        return this.causingEvent;
    }

    @NonNull
    @Generated
    public ZonedDateTime getCreated() {
        return this.created;
    }

    @Generated
    public ZonedDateTime getModified() {
        return this.modified;
    }

    @Generated
    public int getVersion() {
        return this.version;
    }

    @Generated
    public UUID getManualTaskId() {
        return this.manualTaskId;
    }

    @Generated
    public OriginalTraceContext getOriginalTraceContext() {
        return this.originalTraceContext;
    }

    @Generated
    public String getClosingReason() {
        return this.closingReason;
    }

    @Generated
    public ErrorGroup getErrorGroup() {
        return this.errorGroup;
    }

    @Generated
    Error(@NonNull UUID id, @NonNull ErrorState state, @NonNull ErrorEventData errorEventData, @NonNull EventMetadata errorEventMetadata, @NonNull CausingEvent causingEvent, @NonNull ZonedDateTime created, ZonedDateTime modified, int version, UUID manualTaskId, OriginalTraceContext originalTraceContext, String closingReason, ErrorGroup errorGroup) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        if (errorEventData == null) {
            throw new NullPointerException("errorEventData is marked non-null but is null");
        }
        if (errorEventMetadata == null) {
            throw new NullPointerException("errorEventMetadata is marked non-null but is null");
        }
        if (causingEvent == null) {
            throw new NullPointerException("causingEvent is marked non-null but is null");
        }
        if (created == null) {
            throw new NullPointerException("created is marked non-null but is null");
        }
        this.id = id;
        this.state = state;
        this.errorEventData = errorEventData;
        this.errorEventMetadata = errorEventMetadata;
        this.causingEvent = causingEvent;
        this.created = created;
        this.modified = modified;
        this.version = version;
        this.manualTaskId = manualTaskId;
        this.originalTraceContext = originalTraceContext;
        this.closingReason = closingReason;
        this.errorGroup = errorGroup;
    }

    @Generated
    public Error() {
        this.id = Error.$default$id();
    }

    @Generated
    public String toString() {
        return "Error(id=" + String.valueOf(this.getId()) + ", state=" + String.valueOf((Object)this.getState()) + ", errorEventData=" + String.valueOf(this.getErrorEventData()) + ", errorEventMetadata=" + String.valueOf(this.getErrorEventMetadata()) + ", causingEvent=" + String.valueOf(this.getCausingEvent()) + ", created=" + String.valueOf(this.getCreated()) + ", modified=" + String.valueOf(this.getModified()) + ", version=" + this.getVersion() + ", manualTaskId=" + String.valueOf(this.getManualTaskId()) + ", originalTraceContext=" + String.valueOf(this.getOriginalTraceContext()) + ", closingReason=" + this.getClosingReason() + ", errorGroup=" + String.valueOf(this.getErrorGroup()) + ")";
    }

    public static enum ErrorState {
        TEMPORARY_RETRY_PENDING(true, true),
        SEND_TO_MANUALTASK(true, true),
        PERMANENT(true, true),
        TEMPORARY_RETRIED,
        RESOLVE_ON_MANUALTASK,
        PERMANENT_RETRIED,
        DELETE_ON_MANUALTASK(false, true),
        DELETED(false, false);

        private final boolean deleteAllowed;
        private final boolean retryAllowed;

        private ErrorState() {
            this(false, false);
        }

        private ErrorState(boolean deleteAllowed, boolean retryAllowed) {
            this.deleteAllowed = deleteAllowed;
            this.retryAllowed = retryAllowed;
        }

        @Generated
        public boolean isDeleteAllowed() {
            return this.deleteAllowed;
        }

        @Generated
        public boolean isRetryAllowed() {
            return this.retryAllowed;
        }
    }

    @Generated
    public static class ErrorBuilder {
        @Generated
        private boolean id$set;
        @Generated
        private UUID id$value;
        @Generated
        private ErrorState state;
        @Generated
        private ErrorEventData errorEventData;
        @Generated
        private EventMetadata errorEventMetadata;
        @Generated
        private CausingEvent causingEvent;
        @Generated
        private ZonedDateTime created;
        @Generated
        private ZonedDateTime modified;
        @Generated
        private int version;
        @Generated
        private UUID manualTaskId;
        @Generated
        private OriginalTraceContext originalTraceContext;
        @Generated
        private String closingReason;
        @Generated
        private ErrorGroup errorGroup;

        @Generated
        ErrorBuilder() {
        }

        @Generated
        public ErrorBuilder id(@NonNull UUID id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        @Generated
        public ErrorBuilder state(@NonNull ErrorState state) {
            if (state == null) {
                throw new NullPointerException("state is marked non-null but is null");
            }
            this.state = state;
            return this;
        }

        @Generated
        public ErrorBuilder errorEventData(@NonNull ErrorEventData errorEventData) {
            if (errorEventData == null) {
                throw new NullPointerException("errorEventData is marked non-null but is null");
            }
            this.errorEventData = errorEventData;
            return this;
        }

        @Generated
        public ErrorBuilder errorEventMetadata(@NonNull EventMetadata errorEventMetadata) {
            if (errorEventMetadata == null) {
                throw new NullPointerException("errorEventMetadata is marked non-null but is null");
            }
            this.errorEventMetadata = errorEventMetadata;
            return this;
        }

        @Generated
        public ErrorBuilder causingEvent(@NonNull CausingEvent causingEvent) {
            if (causingEvent == null) {
                throw new NullPointerException("causingEvent is marked non-null but is null");
            }
            this.causingEvent = causingEvent;
            return this;
        }

        @Generated
        public ErrorBuilder created(@NonNull ZonedDateTime created) {
            if (created == null) {
                throw new NullPointerException("created is marked non-null but is null");
            }
            this.created = created;
            return this;
        }

        @Generated
        public ErrorBuilder modified(ZonedDateTime modified) {
            this.modified = modified;
            return this;
        }

        @Generated
        public ErrorBuilder version(int version) {
            this.version = version;
            return this;
        }

        @Generated
        public ErrorBuilder manualTaskId(UUID manualTaskId) {
            this.manualTaskId = manualTaskId;
            return this;
        }

        @Generated
        public ErrorBuilder originalTraceContext(OriginalTraceContext originalTraceContext) {
            this.originalTraceContext = originalTraceContext;
            return this;
        }

        @Generated
        public ErrorBuilder closingReason(String closingReason) {
            this.closingReason = closingReason;
            return this;
        }

        @Generated
        public ErrorBuilder errorGroup(ErrorGroup errorGroup) {
            this.errorGroup = errorGroup;
            return this;
        }

        @Generated
        public Error build() {
            UUID id$value = this.id$value;
            if (!this.id$set) {
                id$value = Error.$default$id();
            }
            return new Error(id$value, this.state, this.errorEventData, this.errorEventMetadata, this.causingEvent, this.created, this.modified, this.version, this.manualTaskId, this.originalTraceContext, this.closingReason, this.errorGroup);
        }

        @Generated
        public String toString() {
            return "Error.ErrorBuilder(id$value=" + String.valueOf(this.id$value) + ", state=" + String.valueOf((Object)this.state) + ", errorEventData=" + String.valueOf(this.errorEventData) + ", errorEventMetadata=" + String.valueOf(this.errorEventMetadata) + ", causingEvent=" + String.valueOf(this.causingEvent) + ", created=" + String.valueOf(this.created) + ", modified=" + String.valueOf(this.modified) + ", version=" + this.version + ", manualTaskId=" + String.valueOf(this.manualTaskId) + ", originalTraceContext=" + String.valueOf(this.originalTraceContext) + ", closingReason=" + this.closingReason + ", errorGroup=" + String.valueOf(this.errorGroup) + ")";
        }
    }
}

