/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.kafka;

import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.kafka.clients.admin.AdminClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.KafkaAdmin;
import org.springframework.util.StringUtils;

@Configuration
class TopicConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopicConfiguration.class);
    static final String NAME = "${jeap.errorhandling.topic}";
    static final String DEAD_LETTER_TOPIC_NAME = "${jeap.errorhandling.deadLetterTopicName}";
    static final String ERROR_TOPIC_NAME = "${jeap.messaging.kafka.errorTopicName}";
    @Value(value="${jeap.errorhandling.topic}")
    private String topicName;
    @Value(value="${jeap.errorhandling.deadLetterTopicName}")
    private String deadLetterTopicName;
    @Value(value="${jeap.messaging.kafka.errorTopicName}")
    private String errorTopicName;
    @Value(value="#{${jeap.messaging.kafka.cluster:{}}}")
    private Map<String, Map<String, String>> multiClusterConfiguration = Map.of();

    TopicConfiguration() {
    }

    @PostConstruct
    public void checkTopicsConfiguration() {
        log.info("Configured values for both error topics: deadLetterTopicName={}, errorTopicName={}", (Object)this.deadLetterTopicName, (Object)this.errorTopicName);
        if (!StringUtils.hasText((String)this.deadLetterTopicName)) {
            throw new IllegalArgumentException("Dead letter topic name is required to start this application. Please configure the property ${jeap.errorhandling.deadLetterTopicName}");
        }
        if (!this.deadLetterTopicName.equals(this.errorTopicName)) {
            throw new IllegalArgumentException("A configuration was found for ${jeap.messaging.kafka.errorTopicName} (" + this.errorTopicName + "). This parameter must not be configured for the error handling service.");
        }
        this.multiClusterConfiguration.keySet().forEach(clusterName -> {
            String multiClusterErrorTopicName = this.multiClusterConfiguration.get(clusterName).get("errorTopicName");
            if (StringUtils.hasText((String)multiClusterErrorTopicName) && !this.deadLetterTopicName.equals(multiClusterErrorTopicName)) {
                throw new IllegalArgumentException("A configuration was found for errorTopicName for cluster '" + clusterName + "': '" + multiClusterErrorTopicName + "'. This parameter cannot be different to the value of ${jeap.errorhandling.deadLetterTopicName}, which is '" + this.deadLetterTopicName + "'.");
            }
        });
    }

    @Generated
    public String getTopicName() {
        return this.topicName;
    }

    @Configuration
    @Profile(value={"cloud"})
    private static class TopicConfigurationCloud {
        private final KafkaAdmin kafkaAdmin;
        private final TopicConfiguration topicConfiguration;

        @PostConstruct
        public void checkIfTopicExist() throws ExecutionException, InterruptedException {
            try (AdminClient adminClient = AdminClient.create((Map)this.kafkaAdmin.getConfigurationProperties());){
                adminClient.describeTopics(List.of(this.topicConfiguration.getTopicName())).allTopicNames().get();
            }
        }

        @Generated
        public TopicConfigurationCloud(KafkaAdmin kafkaAdmin, TopicConfiguration topicConfiguration) {
            this.kafkaAdmin = kafkaAdmin;
            this.topicConfiguration = topicConfiguration;
        }
    }
}

