/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.persistence;

import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import ch.admin.bit.jeap.errorhandling.web.api.ErrorGroupListSearchCriteria;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.Generated;
import org.springframework.data.jpa.domain.Specification;

public final class ErrorGroupListSearchSpecification {
    public static Specification<Error> fromCriteria(UUID errorGroupId, ErrorGroupListSearchCriteria criteria) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Predicate> specs = new ArrayList<Predicate>();
            specs.add(ErrorGroupListSearchSpecification.withErrorGroupId(errorGroupId).toPredicate(root, query, criteriaBuilder));
            specs.add(ErrorGroupListSearchSpecification.withStatePermanentOrSendToManualTask().toPredicate(root, query, criteriaBuilder));
            if (criteria != null) {
                criteria.getDateFrom().ifPresent(from -> specs.add(ErrorGroupListSearchSpecification.withFrom(from).toPredicate(root, query, criteriaBuilder)));
                criteria.getDateTo().ifPresent(to -> specs.add(ErrorGroupListSearchSpecification.withTo(to).toPredicate(root, query, criteriaBuilder)));
                criteria.getStacktracePattern().ifPresent(stackTrace -> specs.add(ErrorGroupListSearchSpecification.withStacktrace(stackTrace).toPredicate(root, query, criteriaBuilder)));
                criteria.getMessagePattern().ifPresent(message -> specs.add(ErrorGroupListSearchSpecification.withMessage(message).toPredicate(root, query, criteriaBuilder)));
            }
            return criteriaBuilder.and(specs.toArray(new Predicate[0]));
        };
    }

    private static Specification<Error> withStatePermanentOrSendToManualTask() {
        return (Specification & Serializable)(root, query, builder) -> root.get("state").in(new Object[]{"PERMANENT", "SEND_TO_MANUALTASK"});
    }

    private static Specification<Error> withErrorGroupId(@NotNull UUID errorGroupId) {
        return (Specification & Serializable)(errorRoot, q, builder) -> builder.equal((Expression)errorRoot.get("errorGroup").get("id"), (Object)errorGroupId);
    }

    private static Specification<Error> withFrom(@NotNull ZonedDateTime from) {
        return (Specification & Serializable)(errorRoot, q, builder) -> builder.greaterThanOrEqualTo((Expression)errorRoot.get("created"), (Comparable)from);
    }

    private static Specification<Error> withTo(@NotNull ZonedDateTime to) {
        return (Specification & Serializable)(errorRoot, q, builder) -> builder.lessThanOrEqualTo((Expression)errorRoot.get("created"), (Comparable)to);
    }

    private static Specification<Error> withStacktrace(@NotNull Pattern stacktrace) {
        return (Specification & Serializable)(errorRoot, q, builder) -> {
            Path stackTrace = errorRoot.get("errorEventData").get("stackTrace");
            return builder.isTrue(builder.function("textregexeq", Boolean.class, new Expression[]{stackTrace, builder.literal((Object)stacktrace.pattern())}));
        };
    }

    private static Specification<Error> withMessage(@NotNull Pattern message) {
        return (Specification & Serializable)(errorRoot, q, builder) -> {
            Path stackTrace = errorRoot.get("errorEventData").get("message");
            return builder.isTrue(builder.function("textregexeq", Boolean.class, new Expression[]{stackTrace, builder.literal((Object)message.pattern())}));
        };
    }

    @Generated
    private ErrorGroupListSearchSpecification() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

