/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.error;

import ch.admin.bit.jeap.errorhandling.domain.audit.AuditLogService;
import ch.admin.bit.jeap.errorhandling.domain.error.ErrorFactory;
import ch.admin.bit.jeap.errorhandling.domain.error.ErrorList;
import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupService;
import ch.admin.bit.jeap.errorhandling.domain.manualtask.taskFactory.TaskFactory;
import ch.admin.bit.jeap.errorhandling.domain.metrics.ErrorHandlingMetricsService;
import ch.admin.bit.jeap.errorhandling.domain.resend.scheduler.ScheduledResendService;
import ch.admin.bit.jeap.errorhandling.domain.resend.strategy.ResendingStrategy;
import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.KafkaFailedEventResender;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskDto;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskManagementClient;
import ch.admin.bit.jeap.errorhandling.infrastructure.manualtask.TaskManagementException;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorEventData;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorRepository;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ScheduledResend;
import ch.admin.bit.jeap.errorhandling.web.api.ErrorGroupListSearchCriteria;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ErrorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorService.class);
    private final ErrorRepository errorRepository;
    private final ScheduledResendService scheduledResendService;
    private final KafkaFailedEventResender failedEventResender;
    private final TaskManagementClient taskManagementClient;
    private final TaskFactory taskFactory;
    private final ResendingStrategy resendingStrategy;
    private final ErrorFactory errorFactory;
    private final ErrorHandlingMetricsService errorHandlingMetricsService;
    private final AuditLogService auditLogService;
    private final ErrorGroupService errorGroupService;
    private final String NOT_RETRYABLE = "Error is not in retryable state: ";
    private final String MANUAL_RESEND_NOT_ALLOWED = "Error is not in state to be resend to manual task: ";

    public void handleTemporaryError(Error error) {
        int errorCountForEvent = this.getErrorCountForCausingEvent(error.getCausingEventMetadata().getId());
        Optional<ZonedDateTime> resendRequest = this.resendingStrategy.determineResend(errorCountForEvent, error.getCausingEventMetadata(), error.getErrorEventMetadata(), error.getErrorEventData(), error.getCausingEventMessage());
        if (resendRequest.isEmpty()) {
            log.debug("Stop resending temporary error");
            this.handlePermanentError(error);
        } else {
            error = this.createTemporary(error, resendRequest.get());
            log.info("Schedule resend for temporary error {}", (Object)error);
        }
    }

    public void handlePermanentError(Error error) {
        error = this.createPermanent(error);
        log.info("Saved permanent error {}", (Object)error);
    }

    public void handleUnknownTemporalityError(Error error) {
        log.debug("Handling an error of unknown error temporality as permanent failure.");
        this.handlePermanentError(error);
    }

    @Transactional(readOnly=true)
    public Error getError(UUID errorId) {
        return (Error)this.errorRepository.getReferenceById(errorId);
    }

    @Transactional(readOnly=true)
    public int getErrorCountForCausingEvent(String causingEventId) {
        return this.errorRepository.countErrorsForCausingEvent(causingEventId);
    }

    @Transactional(readOnly=true)
    public ErrorList getPermanentErrorList(int pageIndex, int pageSize) {
        Page<Error> errors = this.errorRepository.findAllPermanent((Pageable)PageRequest.of((int)pageIndex, (int)pageSize));
        return new ErrorList(errors.getTotalElements(), errors.getContent());
    }

    @Transactional(readOnly=true)
    public ErrorList getTemporaryErrorList(int pageIndex, int pageSize) {
        return this.getErrorListByState(Error.ErrorState.TEMPORARY_RETRY_PENDING, pageIndex, pageSize);
    }

    @Transactional(readOnly=true)
    public ErrorList getErrorListByState(Error.ErrorState errorState, int pageIndex, int pageSize) {
        Page<Error> errors = this.errorRepository.findAllByStateEqualsOrderByCreatedDesc(errorState, (Pageable)PageRequest.of((int)pageIndex, (int)pageSize));
        return new ErrorList(errors.getTotalElements(), errors.getContent());
    }

    @Transactional(readOnly=true)
    public boolean isEventDuplicate(String errorEventIdempotenceId) {
        return this.errorRepository.countErrorsByErrorEventIdempotenceId(errorEventIdempotenceId) > 0;
    }

    @Transactional(readOnly=true)
    public ErrorList getErrorListByGroupId(UUID errorGroupId, ErrorGroupListSearchCriteria criteria) {
        Page<Error> errors = this.errorRepository.findByGroupIdAndCriteria(errorGroupId, criteria, criteria.getPageable());
        return new ErrorList(errors.getTotalElements(), errors.getContent());
    }

    public void manualResend(UUID errorId) {
        log.debug("Handling retry request for error {}", (Object)errorId);
        Error error = this.getError(errorId);
        if (!error.getState().isRetryAllowed()) {
            throw new IllegalStateException("Error is not in retryable state: " + String.valueOf((Object)error.getState()));
        }
        this.failedEventResender.resend(error);
        this.auditLogService.logResendCausingEvent(error);
        if (error.getState() == Error.ErrorState.TEMPORARY_RETRY_PENDING) {
            this.scheduledResendService.cancelScheduledResends(error);
        }
        this.setRetried(error);
        log.info("Resend causing event for error {}", (Object)error);
    }

    public void scheduledResend(ScheduledResend scheduledResend) {
        UUID errorId = scheduledResend.getErrorId();
        Error error = this.getError(errorId);
        try {
            this.resendEventForTemporaryError(error);
            this.markErrorAsRetried(scheduledResend, error);
        }
        catch (Exception ex) {
            log.error("Failed to resend event for error {}", (Object)scheduledResend.getErrorId(), (Object)ex);
            this.markErrorAsRetried(scheduledResend, error);
            this.handleTemporaryErrorResendFailure(error);
        }
        log.info("Resend attempt finished for causing event of error {}", (Object)error);
    }

    private void resendEventForTemporaryError(Error error) {
        log.debug("Try resending error {}", (Object)error);
        if (!error.getState().equals((Object)Error.ErrorState.TEMPORARY_RETRY_PENDING)) {
            throw new IllegalStateException("Error is not in retryable state: " + String.valueOf((Object)error.getState()));
        }
        this.failedEventResender.resend(error);
    }

    private void markErrorAsRetried(ScheduledResend scheduledResend, Error error) {
        this.setRetried(error);
        this.scheduledResendService.setResent(scheduledResend);
    }

    private void handleTemporaryErrorResendFailure(Error resentError) {
        Error error = this.errorFactory.newTemporaryErrorFromTemplate(resentError);
        this.handleTemporaryError(error);
    }

    public void delete(UUID errorId, String reason) {
        log.info("Handling delete request for error {}", (Object)errorId);
        Error error = (Error)this.errorRepository.getReferenceById(errorId);
        if (reason != null && !reason.isBlank()) {
            if (reason.length() > 1000) {
                throw new IllegalArgumentException("Reason must be under 1000 characters");
            }
            error.setClosingReason(reason);
        }
        Error.ErrorState state = error.getState();
        switch (state) {
            case PERMANENT: {
                error.setState(Error.ErrorState.DELETE_ON_MANUALTASK);
                this.deleteManualTask(error);
                break;
            }
            case TEMPORARY_RETRY_PENDING: {
                this.scheduledResendService.cancelScheduledResends(error);
                error.setState(Error.ErrorState.DELETED);
                break;
            }
            case SEND_TO_MANUALTASK: {
                error.setState(Error.ErrorState.DELETED);
                break;
            }
            default: {
                throw new IllegalStateException("Error is not in deletable state: " + String.valueOf((Object)error.getState()));
            }
        }
        this.auditLogService.logDeleteError(error);
    }

    Error createPermanent(Error error) {
        error.setState(Error.ErrorState.SEND_TO_MANUALTASK);
        this.createManualTask(error);
        String causingService = error.getErrorEventMetadata().getPublisher().getService();
        this.errorHandlingMetricsService.incrementPermanentCounter(causingService);
        this.errorGroupService.assignToErrorGroup(error);
        return (Error)this.errorRepository.save(error);
    }

    Error createTemporary(Error error, ZonedDateTime resentAt) {
        error.setState(Error.ErrorState.TEMPORARY_RETRY_PENDING);
        UUID id = error.getId();
        error = (Error)this.errorRepository.save(error);
        this.errorHandlingMetricsService.incrementTemporaryCounter();
        this.scheduledResendService.scheduleResend(id, resentAt);
        return error;
    }

    private void setRetried(Error error) {
        Error.ErrorState state = error.getState();
        ErrorEventData eventData = error.getErrorEventData();
        ErrorEventData.Temporality temporality = eventData != null ? eventData.getTemporality() : null;
        block0 : switch (state) {
            case TEMPORARY_RETRY_PENDING: {
                error.setState(Error.ErrorState.TEMPORARY_RETRIED);
                break;
            }
            case PERMANENT: {
                error.setState(Error.ErrorState.RESOLVE_ON_MANUALTASK);
                this.closeManualTask(error);
                break;
            }
            case SEND_TO_MANUALTASK: {
                error.setState(Error.ErrorState.PERMANENT_RETRIED);
                break;
            }
            default: {
                switch (temporality) {
                    case PERMANENT: {
                        error.setState(Error.ErrorState.PERMANENT_RETRIED);
                        break block0;
                    }
                    case TEMPORARY: {
                        error.setState(Error.ErrorState.TEMPORARY_RETRIED);
                        break block0;
                    }
                }
                throw new IllegalStateException("Error is not in retryable state: " + String.valueOf((Object)error.getState()));
            }
        }
    }

    public void createManualTask(Error error) {
        if (error.getState() != Error.ErrorState.SEND_TO_MANUALTASK) {
            throw new IllegalStateException("Error is not in state to be resend to manual task: " + String.valueOf((Object)error.getState()));
        }
        try {
            TaskDto taskDto = this.taskFactory.create(error);
            this.taskManagementClient.createTask(taskDto);
            error.setManualTaskId(taskDto.getId());
            error.setState(Error.ErrorState.PERMANENT);
            this.errorRepository.save(error);
        }
        catch (TaskManagementException e) {
            log.warn("Could not send task to manual task service, retry later", (Throwable)e);
        }
    }

    public void deleteManualTask(Error error) {
        if (error.getState() != Error.ErrorState.DELETE_ON_MANUALTASK) {
            throw new IllegalStateException("Error is not in state to be resend to manual task: " + String.valueOf((Object)error.getState()));
        }
        try {
            this.taskManagementClient.closeTask(error.getManualTaskId());
            error.setState(Error.ErrorState.DELETED);
            this.errorRepository.save(error);
        }
        catch (TaskManagementException e) {
            log.warn("Could not close task to manual task service, retry later", (Throwable)e);
        }
    }

    public void closeManualTask(Error error) {
        if (error.getState() != Error.ErrorState.RESOLVE_ON_MANUALTASK) {
            throw new IllegalStateException("Error is not in state to be resend to manual task: " + String.valueOf((Object)error.getState()));
        }
        try {
            this.taskManagementClient.closeTask(error.getManualTaskId());
            error.setState(Error.ErrorState.PERMANENT_RETRIED);
            this.errorRepository.save(error);
        }
        catch (TaskManagementException e) {
            log.warn("Could not close task to manual task service, retry later", (Throwable)e);
        }
    }

    @Generated
    public ErrorService(ErrorRepository errorRepository, ScheduledResendService scheduledResendService, KafkaFailedEventResender failedEventResender, TaskManagementClient taskManagementClient, TaskFactory taskFactory, ResendingStrategy resendingStrategy, ErrorFactory errorFactory, ErrorHandlingMetricsService errorHandlingMetricsService, AuditLogService auditLogService, ErrorGroupService errorGroupService) {
        this.errorRepository = errorRepository;
        this.scheduledResendService = scheduledResendService;
        this.failedEventResender = failedEventResender;
        this.taskManagementClient = taskManagementClient;
        this.taskFactory = taskFactory;
        this.resendingStrategy = resendingStrategy;
        this.errorFactory = errorFactory;
        this.errorHandlingMetricsService = errorHandlingMetricsService;
        this.auditLogService = auditLogService;
        this.errorGroupService = errorGroupService;
    }
}

