/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.jira;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Positive;
import lombok.Generated;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="jeap.errorhandling.jira")
public class JiraConfigurationProperties
implements InitializingBean {
    @NotBlank
    private String baseUrl;
    private String username;
    private String password;
    private String token;
    @Positive
    private int connectTimeoutMs = 5000;
    @Positive
    private int readTimeoutMs = 20000;

    public void afterPropertiesSet() {
        if (!this.hasUsernameAndPassword() && !this.hasToken()) {
            throw new IllegalStateException("Either username/password or token must be set to use Jira.");
        }
    }

    public boolean hasUsernameAndPassword() {
        return StringUtils.hasText((String)this.username) && StringUtils.hasText((String)this.password);
    }

    public boolean hasToken() {
        return StringUtils.hasText((String)this.token);
    }

    @Generated
    public JiraConfigurationProperties() {
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    @Generated
    public int getReadTimeoutMs() {
        return this.readTimeoutMs;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setConnectTimeoutMs(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    @Generated
    public void setReadTimeoutMs(int readTimeoutMs) {
        this.readTimeoutMs = readTimeoutMs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JiraConfigurationProperties)) {
            return false;
        }
        JiraConfigurationProperties other = (JiraConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectTimeoutMs() != other.getConnectTimeoutMs()) {
            return false;
        }
        if (this.getReadTimeoutMs() != other.getReadTimeoutMs()) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JiraConfigurationProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectTimeoutMs();
        result = result * 59 + this.getReadTimeoutMs();
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JiraConfigurationProperties(baseUrl=" + this.getBaseUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", token=" + this.getToken() + ", connectTimeoutMs=" + this.getConnectTimeoutMs() + ", readTimeoutMs=" + this.getReadTimeoutMs() + ")";
    }
}

