/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.exceptions;

import ch.admin.bit.jeap.errorhandling.domain.exceptions.ErrorGroupAlreadyHasATicketNumberAssignedException;
import ch.admin.bit.jeap.errorhandling.domain.exceptions.ErrorGroupNotFoundException;
import ch.admin.bit.jeap.errorhandling.domain.exceptions.ErrorResponse;
import ch.admin.bit.jeap.errorhandling.domain.exceptions.InvalidUuidException;
import ch.admin.bit.jeap.errorhandling.domain.exceptions.IssueTrackingBadRequest;
import ch.admin.bit.jeap.errorhandling.domain.exceptions.IssueTrackingCommunicationError;
import ch.admin.bit.jeap.errorhandling.domain.exceptions.IssueTrackingServerError;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandler {
    @ExceptionHandler(value={ErrorGroupNotFoundException.class, ErrorGroupAlreadyHasATicketNumberAssignedException.class, InvalidUuidException.class, IssueTrackingBadRequest.class})
    public ResponseEntity<ErrorResponse> handleAsBadRequestWithErrorMessage(RuntimeException ex) {
        ErrorResponse errorResponse = new ErrorResponse(ex.getMessage(), HttpStatus.BAD_REQUEST.value());
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={IssueTrackingCommunicationError.class, IssueTrackingServerError.class})
    public ResponseEntity<ErrorResponse> handleIssueTrackingError(RuntimeException ex) {
        ErrorResponse errorResponse = new ErrorResponse(ex.getMessage(), HttpStatus.BAD_GATEWAY.value());
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.BAD_GATEWAY);
    }
}

