/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.kafka;

import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.ResendFailedException;
import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.recordformat.RecordBinaryFormat;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.CausingEvent;
import ch.admin.bit.jeap.messaging.kafka.KafkaConfiguration;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ResendClusterProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResendClusterProvider.class);
    private final String defaultProducerClusterName;
    private final Set<String> allClusterNames;
    private final Map<String, RecordBinaryFormat> recordBinaryFormatByClusterName;

    public ResendClusterProvider(KafkaProperties kafkaProperties, KafkaConfiguration kafkaConfiguration) {
        this.defaultProducerClusterName = kafkaProperties.getDefaultProducerClusterName();
        this.allClusterNames = kafkaProperties.clusterNames();
        this.recordBinaryFormatByClusterName = this.allClusterNames.stream().map(clusterName -> Map.entry(clusterName, RecordBinaryFormat.requireFormatForCluster(kafkaConfiguration, clusterName))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        log.info("Record binary formats by cluster: {}", this.recordBinaryFormatByClusterName);
    }

    public String getResendClusterNameFor(CausingEvent causingEvent) {
        String clusterNameWhereFailedEventWasConsumed = causingEvent.getMessage().getClusterNameOrDefault(this.defaultProducerClusterName);
        Optional<RecordBinaryFormat> recordBinaryFormatOfMessageOpt = RecordBinaryFormat.of(causingEvent.getMessage().getPayload());
        Optional<RecordBinaryFormat> recordBinaryFormatOfOriginatingCluster = this.findClusterRecordBinaryFormatIfKnown(clusterNameWhereFailedEventWasConsumed);
        if (this.messageFormatUnknownButClusterNameValid(recordBinaryFormatOfMessageOpt, clusterNameWhereFailedEventWasConsumed) || this.recordBinaryFormatMatches(recordBinaryFormatOfOriginatingCluster, recordBinaryFormatOfMessageOpt)) {
            return clusterNameWhereFailedEventWasConsumed;
        }
        if (recordBinaryFormatOfMessageOpt.isEmpty()) {
            throw ResendFailedException.unkownMessageRecordBinaryFormat(causingEvent.getId(), clusterNameWhereFailedEventWasConsumed);
        }
        RecordBinaryFormat recordBinaryFormatOfMessage = recordBinaryFormatOfMessageOpt.get();
        for (String clusterName : this.allClusterNames) {
            RecordBinaryFormat recordBinaryFormatOfAlternativeCluster = this.getClusterRecordBinaryFormat(clusterName);
            if (recordBinaryFormatOfMessage != recordBinaryFormatOfAlternativeCluster) continue;
            log.info("Using alternative cluster '{}' for event '{}' because record format '{}' does not match with original cluster '{}' which is using '{}'", new Object[]{clusterName, causingEvent.getId(), recordBinaryFormatOfMessage, clusterNameWhereFailedEventWasConsumed, recordBinaryFormatOfOriginatingCluster.map(Enum::name).orElse("<unknown>")});
            return clusterName;
        }
        throw ResendFailedException.noSuitableClusterFoundForMessageFormat(causingEvent.getId(), recordBinaryFormatOfMessage);
    }

    private boolean messageFormatUnknownButClusterNameValid(Optional<RecordBinaryFormat> recordBinaryFormatOfMessageOpt, String clusterNameWhereFailedEventWasConsumed) {
        return recordBinaryFormatOfMessageOpt.isEmpty() && this.allClusterNames.contains(clusterNameWhereFailedEventWasConsumed);
    }

    private boolean recordBinaryFormatMatches(Optional<RecordBinaryFormat> recordBinaryFormatOfOriginatingCluster, Optional<RecordBinaryFormat> recordBinaryFormatOfMessage) {
        return recordBinaryFormatOfOriginatingCluster.filter(recordBinaryFormat -> recordBinaryFormat == recordBinaryFormatOfMessage.orElse(null)).isPresent();
    }

    private Optional<RecordBinaryFormat> findClusterRecordBinaryFormatIfKnown(String persistedClusterName) {
        return this.recordBinaryFormatByClusterName.containsKey(persistedClusterName) ? Optional.of(this.getClusterRecordBinaryFormat(persistedClusterName)) : Optional.empty();
    }

    private RecordBinaryFormat getClusterRecordBinaryFormat(String clusterName) {
        return this.recordBinaryFormatByClusterName.get(clusterName);
    }
}

