/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.kafka.recordformat;

import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.ResendFailedException;
import ch.admin.bit.jeap.messaging.kafka.KafkaConfiguration;
import ch.admin.bit.jeap.messaging.kafka.serde.confluent.CustomKafkaAvroSerializer;
import ch.admin.bit.jeap.messaging.kafka.serde.glue.JeapGlueAvroSerializer;
import java.util.Optional;

public enum RecordBinaryFormat {
    CONFLUENT_AVRO(0),
    GLUE_AVRO(3);

    private final byte versionByteValue;

    private RecordBinaryFormat(byte versionByteValue) {
        this.versionByteValue = versionByteValue;
    }

    public byte getVersionByteValue() {
        return this.versionByteValue;
    }

    public static Optional<RecordBinaryFormat> of(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return Optional.empty();
        }
        for (RecordBinaryFormat recordBinaryFormat : RecordBinaryFormat.values()) {
            if (bytes[0] != recordBinaryFormat.versionByteValue) continue;
            return Optional.of(recordBinaryFormat);
        }
        return Optional.empty();
    }

    public static RecordBinaryFormat requireFormatForCluster(KafkaConfiguration kafkaConfiguration, String clusterName) {
        Object serializerConfig = kafkaConfiguration.producerConfig(clusterName).get("value.serializer");
        if (serializerConfig == null) {
            throw ResendFailedException.unknownSerializerForCluster(clusterName);
        }
        if (JeapGlueAvroSerializer.class.getName().equals(serializerConfig) || JeapGlueAvroSerializer.class.equals(serializerConfig)) {
            return GLUE_AVRO;
        }
        if (CustomKafkaAvroSerializer.class.getName().equals(serializerConfig) || CustomKafkaAvroSerializer.class.equals(serializerConfig)) {
            return CONFLUENT_AVRO;
        }
        throw ResendFailedException.unknownSerializerForCluster(clusterName);
    }
}

