/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.persistence;

import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorCountByClusterNameResult;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorGroupListSearchSpecification;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorQueryResult;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorSearchSpecification;
import ch.admin.bit.jeap.errorhandling.web.api.ErrorGroupListSearchCriteria;
import ch.admin.bit.jeap.errorhandling.web.api.ErrorSearchCriteria;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ErrorRepository
extends JpaRepository<Error, UUID>,
JpaSpecificationExecutor<Error> {
    default public Page<Error> findByGroupIdAndCriteria(UUID errorGroupId, ErrorGroupListSearchCriteria criteria, Pageable pageable) {
        return this.findAll(ErrorGroupListSearchSpecification.fromCriteria(errorGroupId, criteria), pageable);
    }

    @Query(value="select e from Error e where (e.state = 'PERMANENT' OR e.state = 'SEND_TO_MANUALTASK') ORDER BY e.created DESC")
    public Page<Error> findAllPermanent(Pageable var1);

    public Page<Error> findAllByStateEqualsOrderByCreatedDesc(Error.ErrorState var1, Pageable var2);

    @Query(value="select count(e) from Error e where e.errorEventMetadata.idempotenceId = ?1")
    public int countErrorsByErrorEventIdempotenceId(String var1);

    @Query(value="select count(e) from Error e where e.causingEvent.metadata.id = ?1")
    public int countErrorsForCausingEvent(String var1);

    @Query(value="select count(e) from Error e where e.state = 'TEMPORARY_RETRY_PENDING'")
    public int countErrorsInStateTemporaryRetryPending();

    @Query(value="select count(e) from Error e where e.state = 'PERMANENT' OR e.state = 'SEND_TO_MANUALTASK'")
    public int countErrorsInStatesPermanentOrSendToManualTask();

    @Query(value="select count(e) from Error e where e.state = 'SEND_TO_MANUALTASK'")
    public int countErrorsInStateSendToManualTask();

    @Query(value="select count(e) from Error e where e.state = 'RESOLVE_ON_MANUALTASK'")
    public int countErrorsInStateResolveOnManualTask();

    @Query(value="select count(e) from Error e where e.state = 'DELETE_ON_MANUALTASK'")
    public int countErrorsInStateDeleteOnManualTask();

    @Query(value="select new ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorCountByClusterNameResult(e.causingEvent.message.clusterName, count(e)) from Error e where e.state in ('PERMANENT', 'TEMPORARY_RETRY_PENDING', 'SEND_TO_MANUALTASK') group by e.causingEvent.message.clusterName")
    public List<ErrorCountByClusterNameResult> countOpenErrorsByStateAndClusterName();

    public Slice<ErrorQueryResult> findIdByStateInAndCreatedBefore(List<Error.ErrorState> var1, ZonedDateTime var2, Pageable var3);

    default public Page<Error> search(ErrorSearchCriteria criteria, Pageable pageable) {
        return this.findAll(ErrorSearchSpecification.fromCriteria(criteria), pageable);
    }

    @Query(value="select distinct e.errorEventMetadata.publisher.service from Error e")
    public List<String> getAllEventSources();

    @Query(value="select distinct e.errorEventData.code from Error e")
    public List<String> getAllErrorCodes();

    @Query(value="select distinct e.causingEvent.metadata.type.name from Error e")
    public List<String> getAllEventNames();

    @Modifying
    @Query(nativeQuery=true, value="DELETE FROM error e WHERE e.id in (:errorIds) ")
    public void deleteAllById(@Param(value="errorIds") Set<UUID> var1);
}

