/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.web.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public abstract class BaseSearchCriteria {
    public static final Integer PAGE_DEFAULT_VALUE = 0;
    public static final Integer SIZE_DEFAULT_VALUE = 10;

    @JsonIgnore
    public Pageable getPageable() {
        return PageRequest.of((int)((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{this.getPageIndex(), PAGE_DEFAULT_VALUE})), (int)((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{this.getPageSize(), SIZE_DEFAULT_VALUE})), (Sort)Sort.by(this.getOrders()));
    }

    protected List<Sort.Order> getOrders() {
        Object[] sort = this.getSort();
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        if (sort != null && sort.length > 0) {
            if (this.hasMultipleColumns((String[])sort)) {
                for (Object sortOrder : sort) {
                    Object[] propertyDirection = ((String)sortOrder).split(",");
                    Assert.isTrue((boolean)this.hasPropertyAndDirection((String[])propertyDirection), (String)String.format("Invalid sort value '%s' ", Arrays.toString(propertyDirection)));
                    orders.add(new Sort.Order(this.getDirection((String)propertyDirection[1]), (String)propertyDirection[0]));
                }
            } else {
                Assert.isTrue((boolean)this.hasPropertyAndDirection((String[])sort), (String)String.format("Invalid sort value '%s' ", Arrays.toString(sort)));
                orders.add(new Sort.Order(this.getDirection((String)sort[1]), (String)sort[0]));
            }
        }
        return orders;
    }

    private boolean hasPropertyAndDirection(String[] array) {
        return array.length == 2;
    }

    private boolean hasMultipleColumns(String[] sort) {
        return sort[0].contains(",");
    }

    private Sort.Direction getDirection(String direction) {
        return Sort.Direction.fromString((String)direction);
    }

    protected abstract Integer getPageIndex();

    protected abstract Integer getPageSize();

    protected abstract String[] getSort();
}

