/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.web.api;

import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupAggregatedData;
import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupAggregatedDataList;
import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupService;
import ch.admin.bit.jeap.errorhandling.web.api.DateTimeUtils;
import ch.admin.bit.jeap.errorhandling.web.api.ErrorGroupDTO;
import ch.admin.bit.jeap.errorhandling.web.api.ErrorGroupResponse;
import ch.admin.bit.jeap.errorhandling.web.api.UpdateFreeTextRequest;
import ch.admin.bit.jeap.errorhandling.web.api.UpdateTicketNumberRequest;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="ErrorGroup")
@RestController
@RequestMapping(value={"/api/error-group"})
public class ErrorGroupController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorGroupController.class);
    private final ErrorGroupService errorGroupService;

    @GetMapping
    @PreAuthorize(value="hasRole('errorgroup','view')")
    public ErrorGroupResponse getGroups(@RequestParam(name="pageIndex", required=false, defaultValue="0") int pageIndex, @RequestParam(name="pageSize", required=false, defaultValue="10") int pageSize) {
        ErrorGroupAggregatedDataList errorGroups = this.errorGroupService.findErrorGroupAggregatedData((Pageable)PageRequest.of((int)pageIndex, (int)pageSize));
        List<ErrorGroupDTO> errorGroupDTOS = errorGroups.groups().stream().map(this::mapToDTO).toList();
        return new ErrorGroupResponse(errorGroups.totalElements(), errorGroupDTOS);
    }

    @PostMapping(value={"/update-ticket-number"})
    @PreAuthorize(value="hasRole('errorgroup','edit')")
    public ResponseEntity<ErrorGroupDTO> updateTicketNumber(@RequestBody @Valid UpdateTicketNumberRequest ticketNumberRequest) {
        UUID groupId;
        try {
            groupId = UUID.fromString(ticketNumberRequest.getErrorGroupId());
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.badRequest().body(null);
        }
        this.errorGroupService.updateTicketNumber(groupId, ticketNumberRequest.getTicketNumber());
        ErrorGroupAggregatedData errorGroupAggregatedData = this.errorGroupService.getErrorGroupAggregatedData(groupId);
        ErrorGroupDTO errorGroupDTO = this.mapToDTO(errorGroupAggregatedData);
        return ResponseEntity.ok((Object)errorGroupDTO);
    }

    @PostMapping(value={"/update-free-text"})
    @PreAuthorize(value="hasRole('errorgroup','edit')")
    public ResponseEntity<ErrorGroupDTO> updateFreeText(@RequestBody @Valid UpdateFreeTextRequest freeTextRequest) {
        UUID groupId;
        try {
            groupId = UUID.fromString(freeTextRequest.getErrorGroupId());
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.badRequest().body(null);
        }
        this.errorGroupService.updateFreeText(groupId, freeTextRequest.getFreeText());
        ErrorGroupAggregatedData errorGroupAggregatedData = this.errorGroupService.getErrorGroupAggregatedData(groupId);
        ErrorGroupDTO errorGroupDTO = this.mapToDTO(errorGroupAggregatedData);
        return ResponseEntity.ok((Object)errorGroupDTO);
    }

    private ErrorGroupDTO mapToDTO(ErrorGroupAggregatedData groupAggregatedData) {
        return new ErrorGroupDTO(groupAggregatedData.getGroupId().toString(), groupAggregatedData.getErrorCount(), groupAggregatedData.getErrorEvent(), groupAggregatedData.getErrorPublisher(), groupAggregatedData.getErrorCode(), groupAggregatedData.getErrorMessage(), DateTimeUtils.timestamp(groupAggregatedData.getFirstErrorAt()), DateTimeUtils.timestamp(groupAggregatedData.getLatestErrorAt()), groupAggregatedData.getTicketNumber(), groupAggregatedData.getFreeText());
    }

    @Generated
    public ErrorGroupController(ErrorGroupService errorGroupService) {
        this.errorGroupService = errorGroupService;
    }
}

