/*
 * Decompiled with CFR 0.152.
 */
package db.migration.common;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class V5_0_0__MigrateCausingEventIdsToBeUnique
extends BaseJavaMigration {
    public void migrate(Context context) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)new SingleConnectionDataSource(context.getConnection(), true));
        List<String> duplicatedIds = this.findDuplicateCausingEventIds(jdbcTemplate);
        for (String id : duplicatedIds) {
            this.fixDuplicateId(id, jdbcTemplate);
        }
    }

    private List<String> findDuplicateCausingEventIds(JdbcTemplate jdbcTemplate) {
        return jdbcTemplate.queryForList("SELECT DISTINCT metadata_id FROM causing_event GROUP BY metadata_id HAVING COUNT(metadata_id) > 1", String.class);
    }

    private void fixDuplicateId(String causingEventMetadataId, JdbcTemplate jdbcTemplate) {
        List<UUID> duplicateCausingEventEntityIds = this.findDuplicateCausingEventIds(causingEventMetadataId, jdbcTemplate);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate);
        this.updateErrorsToReferenceFirstCausingEvent(duplicateCausingEventEntityIds, namedParameterJdbcTemplate);
        this.deleteDuplicateCausingEvents(duplicateCausingEventEntityIds, namedParameterJdbcTemplate);
    }

    private void updateErrorsToReferenceFirstCausingEvent(List<UUID> duplicateCausingEventEntityIds, NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        UUID firstEntityId = duplicateCausingEventEntityIds.get(0);
        MapSqlParameterSource parameters = new MapSqlParameterSource(Map.of("duplicateCausingEventEntityIds", duplicateCausingEventEntityIds, "firstEntityId", firstEntityId));
        namedParameterJdbcTemplate.update("UPDATE error SET causing_event_id = :firstEntityId WHERE causing_event_id IN (:duplicateCausingEventEntityIds)", (SqlParameterSource)parameters);
    }

    private List<UUID> findDuplicateCausingEventIds(String causingEventMetadataId, JdbcTemplate jdbcTemplate) {
        List duplicateCausingEventEntityIds = jdbcTemplate.queryForList("SELECT id FROM causing_event WHERE metadata_id = ?", UUID.class, new Object[]{causingEventMetadataId});
        return duplicateCausingEventEntityIds;
    }

    private void deleteDuplicateCausingEvents(List<UUID> duplicateCausingEventEntityIds, NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        List<UUID> idsToDelete = duplicateCausingEventEntityIds.subList(1, duplicateCausingEventEntityIds.size());
        MapSqlParameterSource deleteParameters = new MapSqlParameterSource(Map.of("idsToDelete", idsToDelete));
        namedParameterJdbcTemplate.update("DELETE FROM causing_event WHERE id IN (:idsToDelete)", (SqlParameterSource)deleteParameters);
    }
}

