/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.persistence;

import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import ch.admin.bit.jeap.errorhandling.web.api.ErrorSearchCriteria;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.springframework.data.jpa.domain.Specification;

public final class ErrorSearchSpecification {
    public static Specification<Error> fromCriteria(ErrorSearchCriteria criteria) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            if (criteria == null) {
                return null;
            }
            ArrayList specs = new ArrayList();
            criteria.getFrom().ifPresent(from -> specs.add(ErrorSearchSpecification.withFrom(from).toPredicate(root, query, criteriaBuilder)));
            criteria.getTo().ifPresent(to -> specs.add(ErrorSearchSpecification.withTo(to).toPredicate(root, query, criteriaBuilder)));
            criteria.getEventName().ifPresent(eventName -> specs.add(ErrorSearchSpecification.withEventName(eventName).toPredicate(root, query, criteriaBuilder)));
            criteria.getTraceId().ifPresent(traceId -> specs.add(ErrorSearchSpecification.withTraceId(traceId).toPredicate(root, query, criteriaBuilder)));
            criteria.getEventId().ifPresent(eventId -> specs.add(ErrorSearchSpecification.withEventId(eventId).toPredicate(root, query, criteriaBuilder)));
            criteria.getServiceName().ifPresent(serviceName -> specs.add(ErrorSearchSpecification.withServiceName(serviceName).toPredicate(root, query, criteriaBuilder)));
            criteria.getStates().ifPresent(states -> specs.add(ErrorSearchSpecification.withState(states).toPredicate(root, query, criteriaBuilder)));
            criteria.getErrorCode().ifPresent(errorCode -> specs.add(ErrorSearchSpecification.withErrorCode(errorCode).toPredicate(root, query, criteriaBuilder)));
            criteria.getStacktrace().ifPresent(stackTrace -> specs.add(ErrorSearchSpecification.withStacktrace(stackTrace).toPredicate(root, query, criteriaBuilder)));
            criteria.getClosingReason().ifPresent(closingReason -> specs.add(ErrorSearchSpecification.withClosingReason(closingReason).toPredicate(root, query, criteriaBuilder)));
            criteria.getTicketNumber().ifPresent(ticketNumber -> specs.add(ErrorSearchSpecification.withTicketNumber(ticketNumber).toPredicate(root, query, criteriaBuilder)));
            return criteriaBuilder.and(specs.toArray(new Predicate[0]));
        };
    }

    private static Specification<Error> withFrom(@NotNull ZonedDateTime from) {
        return (Specification & Serializable)(errorRoot, q, builder) -> builder.greaterThanOrEqualTo((Expression)errorRoot.get("created"), (Comparable)from);
    }

    private static Specification<Error> withTo(@NotNull ZonedDateTime to) {
        return (Specification & Serializable)(errorRoot, q, builder) -> builder.lessThanOrEqualTo((Expression)errorRoot.get("created"), (Comparable)to);
    }

    private static Specification<Error> withEventName(@NotNull String eventName) {
        return (Specification & Serializable)(errorRoot, q, builder) -> builder.equal((Expression)errorRoot.get("causingEvent").get("metadata").get("type").get("name"), (Object)eventName);
    }

    private static Specification<Error> withTraceId(@NotNull String traceId) {
        return (Specification & Serializable)(errorRoot, q, builder) -> builder.equal((Expression)errorRoot.get("originalTraceContext").get("traceIdString"), (Object)traceId);
    }

    private static Specification<Error> withEventId(@NotNull String eventId) {
        return (Specification & Serializable)(errorRoot, q, builder) -> builder.equal((Expression)errorRoot.get("causingEvent").get("metadata").get("id"), (Object)eventId);
    }

    private static Specification<Error> withServiceName(@NotNull String serviceName) {
        return (Specification & Serializable)(errorRoot, q, builder) -> builder.equal((Expression)errorRoot.get("errorEventMetadata").get("publisher").get("service"), (Object)serviceName);
    }

    private static Specification<Error> withState(@NotNull List<Error.ErrorState> states) {
        return (Specification & Serializable)(errorRoot, q, builder) -> errorRoot.get("state").in((Collection)states);
    }

    private static Specification<Error> withErrorCode(@NotNull String errorCode) {
        return (Specification & Serializable)(errorRoot, q, builder) -> builder.equal((Expression)errorRoot.get("errorEventData").get("code"), (Object)errorCode);
    }

    private static Specification<Error> withStacktrace(@NotNull Pattern stacktrace) {
        return (Specification & Serializable)(errorRoot, q, builder) -> {
            Path stackTrace = errorRoot.get("errorEventData").get("stackTrace");
            return builder.isTrue(builder.function("textregexeq", Boolean.class, new Expression[]{stackTrace, builder.literal((Object)stacktrace.pattern())}));
        };
    }

    private static Specification<Error> withClosingReason(@NotNull String reason) {
        return (Specification & Serializable)(errorRoot, q, builder) -> builder.like((Expression)errorRoot.get("closingReason"), "%" + reason + "%");
    }

    private static Specification<Error> withTicketNumber(@NotNull String ticketNumber) {
        return (Specification & Serializable)(errorRoot, q, builder) -> {
            Join errorGroupJoin = errorRoot.join("errorGroup", JoinType.INNER);
            return builder.equal((Expression)errorGroupJoin.get("ticketNumber"), (Object)ticketNumber);
        };
    }

    @Generated
    private ErrorSearchSpecification() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

