/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.eventHandler;

import ch.admin.bit.jeap.domainevent.avro.AvroDomainEventIdentity;
import ch.admin.bit.jeap.domainevent.avro.AvroDomainEventPublisher;
import ch.admin.bit.jeap.domainevent.avro.AvroDomainEventType;
import ch.admin.bit.jeap.errorhandling.domain.eventHandler.NonAvroMessageException;
import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.DomainEventDeserializerProvider;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.CausingEvent;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorEventData;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.EventMessage;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.EventMetadata;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.EventPublisher;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.EventType;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.MessageHeader;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.OriginalTraceContext;
import ch.admin.bit.jeap.messaging.avro.errorevent.ErrorTypeReference;
import ch.admin.bit.jeap.messaging.avro.errorevent.FailedMessageMetadata;
import ch.admin.bit.jeap.messaging.avro.errorevent.MessageProcessingFailedEvent;
import ch.admin.bit.jeap.messaging.avro.errorevent.MessageProcessingFailedPayload;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.tracing.TraceContext;
import ch.admin.bit.jeap.messaging.kafka.tracing.TraceContextProvider;
import jakarta.annotation.PreDestroy;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.avro.generic.GenericData;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class ErrorEventMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorEventMapper.class);
    private static final String EVENT_ID = "eventId";
    private final TraceContextProvider traceContextProvider;
    private final Map<String, Deserializer<GenericData.Record>> deserializersByClusterName;

    ErrorEventMapper(DomainEventDeserializerProvider deserializerFactory, TraceContextProvider traceContextProvider, KafkaProperties kafkaProperties) {
        this.deserializersByClusterName = kafkaProperties.clusterNames().stream().collect(Collectors.toMap(clusterName -> clusterName, deserializerFactory::getGenericRecordDomainEventDeserializer));
        this.traceContextProvider = traceContextProvider;
    }

    CausingEvent toCausingEvent(String clusterName, MessageProcessingFailedEvent errorEvent) {
        return CausingEvent.builder().metadata(this.extractCausingEventMetadata(clusterName, errorEvent)).message(this.extractCausingEventMessage(clusterName, errorEvent)).headers(this.extractCausingEventHeaders(errorEvent)).build();
    }

    private List<MessageHeader> extractCausingEventHeaders(MessageProcessingFailedEvent errorEvent) {
        Optional optionalFailedMessageMetadata = errorEvent.getPayload().getOptionalFailedMessageMetadata();
        if (optionalFailedMessageMetadata.isEmpty()) {
            return List.of();
        }
        Map headers = ((FailedMessageMetadata)optionalFailedMessageMetadata.get()).getHeaders();
        if (headers == null) {
            return List.of();
        }
        return headers.entrySet().stream().map(entry -> MessageHeader.builder().headerName((String)entry.getKey()).headerValue(((ByteBuffer)entry.getValue()).array()).build()).toList();
    }

    Error toError(MessageProcessingFailedEvent errorEvent, CausingEvent causingEvent) {
        return Error.builder().state(this.initialState(errorEvent)).causingEvent(causingEvent).errorEventData(this.extractErrorEventData(errorEvent)).errorEventMetadata(this.extractErrorEventMetadata(errorEvent)).created(ZonedDateTime.now()).closingReason("").originalTraceContext(this.retrieveTraceContextFromCurrentTraceContext()).build();
    }

    private OriginalTraceContext retrieveTraceContextFromCurrentTraceContext() {
        try {
            TraceContext traceContext = this.traceContextProvider.getTraceContext();
            return OriginalTraceContext.builder().traceIdHigh(traceContext.getTraceIdHigh()).traceId(traceContext.getTraceId()).spanId(traceContext.getSpanId()).parentSpanId(traceContext.getParentSpanId()).traceIdString(traceContext.getTraceIdString()).build();
        }
        catch (Exception e) {
            log.error("Error retrieving current trace context. Returning null.", (Throwable)e);
            return null;
        }
    }

    private Error.ErrorState initialState(MessageProcessingFailedEvent errorEvent) {
        ErrorEventData.Temporality temporality = ErrorEventData.Temporality.valueOf(errorEvent.getReferences().getErrorType().getTemporality());
        return temporality == ErrorEventData.Temporality.TEMPORARY ? Error.ErrorState.TEMPORARY_RETRY_PENDING : Error.ErrorState.PERMANENT;
    }

    private EventMetadata extractCausingEventMetadata(String clusterName, MessageProcessingFailedEvent errorEvent) {
        Optional optionalFailedMessageMetadata = errorEvent.getPayload().getOptionalFailedMessageMetadata();
        return optionalFailedMessageMetadata.map(this::createEventMetadataFromFailedEvent).orElseGet(() -> this.createEventMetadataByDeserializingCausingEvent(clusterName, errorEvent));
    }

    private EventMetadata createEventMetadataByDeserializingCausingEvent(String clusterName, MessageProcessingFailedEvent errorEvent) {
        String causingMessageTopic = errorEvent.getReferences().getMessage().getTopicName();
        GenericData.Record causingEvent = this.tryDeserializeIfAvro(errorEvent, clusterName, causingMessageTopic);
        EventMetadata.EventMetadataBuilder eventMetadataBuilder = EventMetadata.builder();
        GenericData.Record identity = (GenericData.Record)causingEvent.get("identity");
        String messageId = this.getMessageId(identity);
        eventMetadataBuilder.id(messageId).idempotenceId(this.toString(identity.get("idempotenceId"))).created(ZonedDateTime.ofInstant(Instant.ofEpochMilli((Long)identity.get("created")), ZoneId.of("UTC")));
        GenericData.Record publisher = (GenericData.Record)causingEvent.get("publisher");
        eventMetadataBuilder.publisher(EventPublisher.builder().system(this.toString(publisher.get("system"))).service(this.toString(publisher.get("service"))).build());
        GenericData.Record type = (GenericData.Record)causingEvent.get("type");
        eventMetadataBuilder.type(EventType.builder().name(this.toString(type.get("name"))).version(this.toString(type.get("version"))).build());
        return eventMetadataBuilder.build();
    }

    private EventMetadata createEventMetadataFromFailedEvent(FailedMessageMetadata failedMessageMetadata) {
        EventMetadata.EventMetadataBuilder eventMetadataBuilder = EventMetadata.builder();
        eventMetadataBuilder.id(failedMessageMetadata.getEventId()).idempotenceId(failedMessageMetadata.getIdempotenceId()).created(ZonedDateTime.ofInstant(failedMessageMetadata.getCreated(), ZoneId.of("UTC")));
        eventMetadataBuilder.publisher(EventPublisher.builder().system(failedMessageMetadata.getSystem()).service(failedMessageMetadata.getService()).build());
        eventMetadataBuilder.type(EventType.builder().name(failedMessageMetadata.getMessageTypeName()).version(failedMessageMetadata.getMessageTypeVersion()).build());
        return eventMetadataBuilder.build();
    }

    private GenericData.Record tryDeserializeIfAvro(MessageProcessingFailedEvent messageProcessingFailedEvent, String clusterName, String causingMessageTopic) {
        byte[] causingMessagePayload = messageProcessingFailedEvent.getPayload().getOriginalMessage().array();
        try {
            Deserializer<GenericData.Record> avroDeserializer = this.deserializersByClusterName.get(clusterName);
            return (GenericData.Record)avroDeserializer.deserialize(causingMessageTopic, causingMessagePayload);
        }
        catch (Exception ex) {
            throw NonAvroMessageException.of(messageProcessingFailedEvent, ex);
        }
    }

    private String getMessageId(GenericData.Record identity) {
        boolean hasEventId = identity.getSchema().getField(EVENT_ID) != null;
        return hasEventId ? this.toString(identity.get(EVENT_ID)) : this.toString(identity.get("id"));
    }

    private EventMetadata extractErrorEventMetadata(MessageProcessingFailedEvent errorEvent) {
        AvroDomainEventIdentity srcEventIdentity = errorEvent.getIdentity();
        AvroDomainEventType srcEventTyp = errorEvent.getType();
        AvroDomainEventPublisher srcEventPublisher = errorEvent.getPublisher();
        return EventMetadata.builder().id(srcEventIdentity.getEventId()).idempotenceId(srcEventIdentity.getIdempotenceId()).created(srcEventIdentity.getCreatedZoned()).type(EventType.builder().name(srcEventTyp.getName()).version(srcEventTyp.getVersion()).build()).publisher(EventPublisher.builder().service(srcEventPublisher.getService()).system(srcEventPublisher.getSystem()).build()).build();
    }

    private EventMessage extractCausingEventMessage(String clusterName, MessageProcessingFailedEvent errorEvent) {
        return EventMessage.builder().payload(errorEvent.getPayload().getOriginalMessage().array()).key(errorEvent.getPayload().getOriginalKey() == null ? null : errorEvent.getPayload().getOriginalKey().array()).topic(errorEvent.getReferences().getMessage().getTopicName()).clusterName(clusterName).partition(Long.parseLong(errorEvent.getReferences().getMessage().getPartition())).offset(Long.parseLong(errorEvent.getReferences().getMessage().getOffset())).build();
    }

    private ErrorEventData extractErrorEventData(MessageProcessingFailedEvent errorEvent) {
        ErrorTypeReference errorTypeReference = errorEvent.getReferences().getErrorType();
        MessageProcessingFailedPayload errorPayload = errorEvent.getPayload();
        return ErrorEventData.builder().code(errorTypeReference.getCode()).temporality(ErrorEventData.Temporality.valueOf(errorTypeReference.getTemporality())).message(this.replaceNullCharWithBlank(errorPayload.getErrorMessage())).description(errorPayload.getErrorDescription()).stackTrace(this.replaceNullCharWithBlank(errorPayload.getStackTrace())).stackTraceHash(errorPayload.getStackTraceHash()).build();
    }

    private String replaceNullCharWithBlank(String message) {
        if (message == null) {
            return null;
        }
        return message.replace('\u0000', ' ');
    }

    @PreDestroy
    private void closeKafkaAvroDeserializers() {
        this.deserializersByClusterName.values().forEach(Deserializer::close);
    }

    private String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence) {
            CharSequence cs = (CharSequence)o;
            return cs.toString();
        }
        throw new IllegalArgumentException("Expected a CharSequence instance (i.e. an avro string), got " + o.getClass().getName() + " instead.");
    }
}

