/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.contributor;

import ch.admin.bit.jeap.initializer.contributor.ProjectContributor;
import ch.admin.bit.jeap.initializer.model.ProjectRequest;
import ch.admin.bit.jeap.initializer.model.ProjectTemplate;
import ch.admin.bit.jeap.initializer.util.FileUtils;
import io.micrometer.common.util.StringUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.springframework.stereotype.Component;

@Component
public class JavaPackageRenamerContributor
implements ProjectContributor {
    @Override
    public void contribute(Path projectRoot, ProjectRequest projectRequest, ProjectTemplate template) {
        if (StringUtils.isBlank((String)template.getBasePackage()) || StringUtils.isBlank((String)projectRequest.getBasePackage())) {
            return;
        }
        FileUtils.replaceInFiles("(.*).java", projectRoot, template.getBasePackage(), projectRequest.getBasePackage());
        Path runConfigurationsFolder = Path.of(String.valueOf(projectRoot) + "/.idea/runConfigurations", new String[0]);
        if (Files.exists(runConfigurationsFolder, new LinkOption[0])) {
            FileUtils.replaceInFiles("(.*).xml", runConfigurationsFolder, template.getBasePackage(), projectRequest.getBasePackage());
        }
    }
}

