/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.contributor;

import ch.admin.bit.jeap.initializer.contributor.ProjectContributor;
import ch.admin.bit.jeap.initializer.model.ProjectRequest;
import ch.admin.bit.jeap.initializer.model.ProjectTemplate;
import ch.admin.bit.jeap.initializer.util.FileUtils;
import io.micrometer.common.util.StringUtils;
import java.nio.file.Path;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PropertyFilesContributor
implements ProjectContributor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropertyFilesContributor.class);
    private static final String TEMPLATE_CONTEXT_PATH = "jme-jeap-nivel-quadrel-project-template";

    @Override
    public void contribute(Path projectRoot, ProjectRequest projectRequest, ProjectTemplate template) {
        if (StringUtils.isBlank((String)template.getSystemName()) || StringUtils.isBlank((String)projectRequest.getSystemName()) || StringUtils.isBlank((String)template.getArtifactId()) || StringUtils.isBlank((String)projectRequest.getArtifactId())) {
            return;
        }
        FileUtils.replaceInFiles("application(.*).yml", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        FileUtils.replaceInFiles("application(.*).yaml", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        FileUtils.replaceInFiles("application(.*).properties", projectRoot, template.getArtifactId(), projectRequest.getArtifactId());
        String applicationContextPath = this.getContextPathFromProjectRequest(projectRequest);
        if (applicationContextPath != null) {
            FileUtils.replaceInFiles("application(.*).yml", projectRoot, TEMPLATE_CONTEXT_PATH, applicationContextPath);
            FileUtils.replaceInFiles("application(.*).yaml", projectRoot, TEMPLATE_CONTEXT_PATH, applicationContextPath);
            FileUtils.replaceInFiles("application(.*).properties", projectRoot, TEMPLATE_CONTEXT_PATH, applicationContextPath);
        }
        FileUtils.replaceInFiles("application(.*).yml", projectRoot, template.getSystemName(), projectRequest.getSystemName());
        FileUtils.replaceInFiles("application(.*).yaml", projectRoot, template.getSystemName(), projectRequest.getSystemName());
        FileUtils.replaceInFiles("application(.*).properties", projectRoot, template.getSystemName(), projectRequest.getSystemName());
        FileUtils.replaceInFiles("environment(.*).ts", projectRoot, template.getSystemName(), projectRequest.getSystemName());
    }

    @Override
    public int getOrder() {
        return -2147483548;
    }

    private String getContextPathFromProjectRequest(ProjectRequest projectRequest) {
        if (projectRequest == null) {
            return null;
        }
        Map<String, String> templateParameters = projectRequest.getTemplateParameters();
        return templateParameters != null ? templateParameters.get("applicationContextPath") : null;
    }
}

