/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.template;

import ch.admin.bit.jeap.initializer.config.JeapInitializerProperties;
import ch.admin.bit.jeap.initializer.config.ProjectTemplateProperties;
import ch.admin.bit.jeap.initializer.git.GitService;
import ch.admin.bit.jeap.initializer.model.ProjectTemplate;
import ch.admin.bit.jeap.initializer.template.TemplateException;
import ch.admin.bit.jeap.initializer.template.TemplateRepository;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.util.Set;
import lombok.Generated;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
class CachingTemplateRepository
implements TemplateRepository {
    private final JeapInitializerProperties initializerProperties;
    private final GitService gitService;
    private final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory()).setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE);

    @Override
    public Set<String> getTemplateKeys() {
        return Set.copyOf(this.initializerProperties.getTemplates().keySet());
    }

    @Override
    @Cacheable(value={"templateListCache"})
    public ProjectTemplate getTemplate(String key) {
        return this.loadTemplate(key);
    }

    private ProjectTemplate loadTemplate(String key) {
        ProjectTemplateProperties templateProperties = this.initializerProperties.getTemplates().get(key);
        if (templateProperties == null) {
            return null;
        }
        ProjectTemplate template = this.loadTemplateContent(templateProperties);
        template.setKey(key);
        template.setRepositoryConfiguration(templateProperties.getRepositoryConfiguration());
        template.setGitOpsRepositoryConfiguration(templateProperties.getGitOpsRepositoryConfiguration());
        Assert.hasText((String)template.getName(), (String)"'name' property must be set for template %s.".formatted(key));
        Assert.hasText((String)template.getBasePackage(), (String)"'basePackage' property must be set for template %s.".formatted(key));
        Assert.hasText((String)template.getSystemName(), (String)"'systemName' property must be set for template %s.".formatted(key));
        Assert.hasText((String)template.getArtifactId(), (String)"'artifactId' property must be set for template %s.".formatted(key));
        Assert.hasText((String)template.getGroupId(), (String)"'groupId' property must be set for template %s.".formatted(key));
        return template;
    }

    private ProjectTemplate loadTemplateContent(ProjectTemplateProperties templateProperties) {
        try {
            String content = this.gitService.getFileContentFromRepository(templateProperties.getRepositoryConfiguration(), "initializer.yaml");
            return (ProjectTemplate)this.objectMapper.readValue(content, ProjectTemplate.class);
        }
        catch (IOException cause) {
            throw TemplateException.templateLoadingFailed(cause);
        }
    }

    @Generated
    public CachingTemplateRepository(JeapInitializerProperties initializerProperties, GitService gitService) {
        this.initializerProperties = initializerProperties;
        this.gitService = gitService;
    }
}

