/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.contributor;

import ch.admin.bit.jeap.initializer.config.JeapInitializerProperties;
import ch.admin.bit.jeap.initializer.contributor.ProjectContributor;
import ch.admin.bit.jeap.initializer.model.ProjectRequest;
import ch.admin.bit.jeap.initializer.model.ProjectTemplate;
import ch.admin.bit.jeap.initializer.util.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ParameterReplacementContributor
implements ProjectContributor {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("INITIALIZER PARAMETER (.+) VALUE ([a-zA-Z0-9_\\-.]+)");
    private final Pattern sourceFilesPattern;

    public ParameterReplacementContributor(JeapInitializerProperties jeapInitializerProperties) {
        this.sourceFilesPattern = jeapInitializerProperties.getSourceFilesPattern();
    }

    @Override
    public void contribute(Path projectRoot, ProjectRequest projectRequest, ProjectTemplate template) throws IOException {
        FileUtils.walkMatchingFiles(projectRoot, this.sourceFilesPattern, path -> this.replaceParameters(path, projectRequest));
    }

    @Override
    public int getOrder() {
        return -2147483638;
    }

    private void replaceParameters(Path path, ProjectRequest projectRequest) throws IOException {
        ArrayList<String> lines = new ArrayList<String>(Files.readAllLines(path));
        HashMap params = new HashMap();
        List updatedLines = lines.stream().filter(line -> !ParameterReplacementContributor.matchParameterDefinitionLineExtractingParameters(line, params)).map(line -> this.replaceParams((String)line, params, projectRequest)).collect(Collectors.toCollection(ArrayList::new));
        if (!updatedLines.equals(lines)) {
            Files.write(path, (Iterable<? extends CharSequence>)updatedLines, new OpenOption[0]);
        }
    }

    private static boolean matchParameterDefinitionLineExtractingParameters(String line, Map<String, String> params) {
        Matcher matcher = PARAMETER_PATTERN.matcher(line);
        boolean found = false;
        while (matcher.find()) {
            String parameterName = matcher.group(1);
            String parameterValue = matcher.group(2);
            params.put(parameterName, parameterValue);
            found = true;
        }
        return found;
    }

    private String replaceParams(String line, Map<String, String> params, ProjectRequest projectRequest) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String parameterName = entry.getKey();
            String valueToReplaceInFile = entry.getValue();
            String newValue = projectRequest.getParameterValue(parameterName);
            line = line.replace(valueToReplaceInFile, newValue);
        }
        return line;
    }
}

