/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.model;

import ch.admin.bit.jeap.initializer.model.SelectedModule;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

@Schema(description="Request body for generating a project")
public class ProjectRequest {
    @Schema(description="Name of the template to use", defaultValue="jeap-scs")
    private String template = "jeap-scs";
    @Schema(description="System name to use (i.e. jme, via, wvs)", defaultValue="jme")
    private String systemName = "jme";
    @Schema(description="Federal Department (i.e. BIT, BAZG, ...", defaultValue="BIT")
    private String department = "BIT";
    @Schema(description="Name of the application to generate", defaultValue="My jEAP Project")
    private String applicationName = "jEAP Project";
    @Schema(description="Base Java package to use", defaultValue="ch.admin.bit.jme")
    private String basePackage = "ch.admin.bit.jme";
    @Schema(description="Maven ArtifactId to use", defaultValue="my-app")
    private String artifactId = "my-app";
    @Schema(description="Maven GroupId to use", defaultValue="ch.admin.bit")
    private String groupId = "ch.admin.bit";
    @Schema(description="Additional template parameters")
    private Map<String, String> templateParameters = new HashMap<String, String>();
    @Schema(description="Optional template module selection with their module parameter values")
    private List<SelectedModule> selectedTemplateModules = new ArrayList<SelectedModule>();

    public Set<String> getSelectedModuleIds() {
        if (this.selectedTemplateModules == null) {
            return Set.of();
        }
        return this.selectedTemplateModules.stream().map(SelectedModule::getId).collect(Collectors.toSet());
    }

    public String getParameterValue(String parameterName) {
        if (this.templateParameters.containsKey(parameterName)) {
            return this.templateParameters.get(parameterName);
        }
        return this.selectedTemplateModules.stream().filter(module -> module.getModuleParameters().containsKey(parameterName)).map(module -> module.getModuleParameters().get(parameterName)).findFirst().orElseGet(() -> this.requestParameterValue(parameterName));
    }

    private String requestParameterValue(String parameterName) {
        Map<String, String> requestParameters = Map.of("template", this.template, "systemName", this.systemName, "department", this.department, "applicationName", this.applicationName, "basePackage", this.basePackage, "artifactId", this.artifactId, "groupId", this.groupId);
        if (requestParameters.containsKey(parameterName)) {
            return requestParameters.get(parameterName);
        }
        return "<missing value for parameter %s>".formatted(parameterName);
    }

    @Generated
    public ProjectRequest() {
    }

    @Generated
    public String getTemplate() {
        return this.template;
    }

    @Generated
    public String getSystemName() {
        return this.systemName;
    }

    @Generated
    public String getDepartment() {
        return this.department;
    }

    @Generated
    public String getApplicationName() {
        return this.applicationName;
    }

    @Generated
    public String getBasePackage() {
        return this.basePackage;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public Map<String, String> getTemplateParameters() {
        return this.templateParameters;
    }

    @Generated
    public List<SelectedModule> getSelectedTemplateModules() {
        return this.selectedTemplateModules;
    }

    @Generated
    public void setTemplate(String template) {
        this.template = template;
    }

    @Generated
    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    @Generated
    public void setDepartment(String department) {
        this.department = department;
    }

    @Generated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Generated
    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    @Generated
    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Generated
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Generated
    public void setTemplateParameters(Map<String, String> templateParameters) {
        this.templateParameters = templateParameters;
    }

    @Generated
    public void setSelectedTemplateModules(List<SelectedModule> selectedTemplateModules) {
        this.selectedTemplateModules = selectedTemplateModules;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectRequest)) {
            return false;
        }
        ProjectRequest other = (ProjectRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$systemName = this.getSystemName();
        String other$systemName = other.getSystemName();
        if (this$systemName == null ? other$systemName != null : !this$systemName.equals(other$systemName)) {
            return false;
        }
        String this$department = this.getDepartment();
        String other$department = other.getDepartment();
        if (this$department == null ? other$department != null : !this$department.equals(other$department)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        String this$basePackage = this.getBasePackage();
        String other$basePackage = other.getBasePackage();
        if (this$basePackage == null ? other$basePackage != null : !this$basePackage.equals(other$basePackage)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        Map<String, String> this$templateParameters = this.getTemplateParameters();
        Map<String, String> other$templateParameters = other.getTemplateParameters();
        if (this$templateParameters == null ? other$templateParameters != null : !((Object)this$templateParameters).equals(other$templateParameters)) {
            return false;
        }
        List<SelectedModule> this$selectedTemplateModules = this.getSelectedTemplateModules();
        List<SelectedModule> other$selectedTemplateModules = other.getSelectedTemplateModules();
        return !(this$selectedTemplateModules == null ? other$selectedTemplateModules != null : !((Object)this$selectedTemplateModules).equals(other$selectedTemplateModules));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProjectRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $systemName = this.getSystemName();
        result = result * 59 + ($systemName == null ? 43 : $systemName.hashCode());
        String $department = this.getDepartment();
        result = result * 59 + ($department == null ? 43 : $department.hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        String $basePackage = this.getBasePackage();
        result = result * 59 + ($basePackage == null ? 43 : $basePackage.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        Map<String, String> $templateParameters = this.getTemplateParameters();
        result = result * 59 + ($templateParameters == null ? 43 : ((Object)$templateParameters).hashCode());
        List<SelectedModule> $selectedTemplateModules = this.getSelectedTemplateModules();
        result = result * 59 + ($selectedTemplateModules == null ? 43 : ((Object)$selectedTemplateModules).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProjectRequest(template=" + this.getTemplate() + ", systemName=" + this.getSystemName() + ", department=" + this.getDepartment() + ", applicationName=" + this.getApplicationName() + ", basePackage=" + this.getBasePackage() + ", artifactId=" + this.getArtifactId() + ", groupId=" + this.getGroupId() + ", templateParameters=" + String.valueOf(this.getTemplateParameters()) + ", selectedTemplateModules=" + String.valueOf(this.getSelectedTemplateModules()) + ")";
    }
}

