/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.config;

import ch.admin.bit.jeap.initializer.config.ProjectTemplateProperties;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="jeap.initializer")
public class JeapInitializerProperties
implements InitializingBean {
    private Duration templateCacheDuration = Duration.ofHours(4L);
    private Pattern sourceFilesPattern = Pattern.compile("Dockerfile|Jenkinsfile.*|(.+\\.(md|html|css|java|xml|yaml|yml|properties|json|conf|ts))", 2);
    private Map<String, ProjectTemplateProperties> templates = new LinkedHashMap<String, ProjectTemplateProperties>();

    public void afterPropertiesSet() {
        this.templates.keySet().forEach(templateKey -> {
            ProjectTemplateProperties template = this.templates.get(templateKey);
            Assert.notNull((Object)template.getRepositoryConfiguration(), (String)"'repositoryConfiguration' property block must be set for template %s.".formatted(templateKey));
            Assert.hasText((String)template.getRepositoryConfiguration().getUrl(), (String)"'repositoryConfiguration.url' property must be set for template %s.".formatted(templateKey));
        });
    }

    @Generated
    public Duration getTemplateCacheDuration() {
        return this.templateCacheDuration;
    }

    @Generated
    public Pattern getSourceFilesPattern() {
        return this.sourceFilesPattern;
    }

    @Generated
    public Map<String, ProjectTemplateProperties> getTemplates() {
        return this.templates;
    }

    @Generated
    public void setTemplateCacheDuration(Duration templateCacheDuration) {
        this.templateCacheDuration = templateCacheDuration;
    }

    @Generated
    public void setSourceFilesPattern(Pattern sourceFilesPattern) {
        this.sourceFilesPattern = sourceFilesPattern;
    }

    @Generated
    public void setTemplates(Map<String, ProjectTemplateProperties> templates) {
        this.templates = templates;
    }
}

