/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.contributor;

import ch.admin.bit.jeap.initializer.contributor.ProjectContributor;
import ch.admin.bit.jeap.initializer.model.ProjectRequest;
import ch.admin.bit.jeap.initializer.model.ProjectTemplate;
import ch.admin.bit.jeap.initializer.util.FileProcessingException;
import io.micrometer.common.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FolderRenamerContributor
implements ProjectContributor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FolderRenamerContributor.class);

    @Override
    public void contribute(Path projectRoot, ProjectRequest projectRequest, ProjectTemplate template) {
        if (StringUtils.isBlank((String)template.getBasePackage()) || StringUtils.isBlank((String)projectRequest.getBasePackage())) {
            return;
        }
        String sourcePackageFolder = template.getBasePackage().replace(".", File.separator);
        String targetPackageFolder = projectRequest.getBasePackage().replace(".", File.separator);
        try (Stream<Path> stream = Files.walk(projectRoot, new FileVisitOption[0]);){
            List<Path> srcFolders = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().equalsIgnoreCase("src")).toList();
            srcFolders.forEach(srcFolder -> {
                FolderRenamerContributor.moveMavenPath("/main/java/", srcFolder, sourcePackageFolder, targetPackageFolder);
                FolderRenamerContributor.moveMavenPath("/test/java/", srcFolder, sourcePackageFolder, targetPackageFolder);
            });
        }
        catch (IOException ioException) {
            throw FileProcessingException.ioException(ioException);
        }
    }

    private static void moveMavenPath(String mavenPath, Path srcFolder, String sourcePackageFolder, String targetPackageFolder) {
        Path tgt;
        Path sourcePath = Path.of(srcFolder.toString() + mavenPath + sourcePackageFolder, new String[0]);
        Path targetPath = Path.of(srcFolder.toString() + mavenPath + targetPackageFolder, new String[0]);
        if (!Files.exists(sourcePath, new LinkOption[0])) {
            return;
        }
        Path src = sourcePath.toAbsolutePath().normalize();
        if (src.equals(tgt = targetPath.toAbsolutePath().normalize())) {
            return;
        }
        try {
            if (!tgt.startsWith(src)) {
                Files.createDirectories(tgt.getParent(), new FileAttribute[0]);
                FolderRenamerContributor.moveAtomicWithFallback(src, tgt);
                log.debug("Moved source path {} to {}", (Object)src, (Object)tgt);
            } else {
                FolderRenamerContributor.moveToSubDir(src, tgt);
                log.debug("Moved source path {} to subpath {}", (Object)src, (Object)tgt);
            }
        }
        catch (IOException e) {
            throw FileProcessingException.ioException(e);
        }
    }

    private static void moveToSubDir(Path src, Path tgt) throws IOException {
        Path sourceParent = src.getParent();
        if (sourceParent == null) {
            throw new IllegalArgumentException("Source directory must have a parent: " + String.valueOf(src));
        }
        String sourceDirname = src.getFileName().toString();
        Path tmp = sourceParent.resolve(sourceDirname + ".tmp-" + String.valueOf(UUID.randomUUID()));
        FolderRenamerContributor.moveAtomicWithFallback(src, tmp);
        Files.createDirectories(tgt.getParent(), new FileAttribute[0]);
        FolderRenamerContributor.moveAtomicWithFallback(tmp, tgt);
    }

    private static void moveAtomicWithFallback(Path from, Path to) throws IOException {
        try {
            Files.move(from, to, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            Files.move(from, to, new CopyOption[0]);
        }
    }

    @Override
    public int getOrder() {
        return -2147483598;
    }
}

