/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.git;

import ch.admin.bit.jeap.initializer.git.GitException;
import ch.admin.bit.jeap.initializer.git.GitService;
import ch.admin.bit.jeap.initializer.model.GitRepositoryConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import lombok.Generated;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.StringUtils;

@Service
public class DefaultGitService
implements GitService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultGitService.class);

    @Override
    public void cloneRepositoryAtPath(GitRepositoryConfiguration configuration, Path localPath) {
        log.info("Cloning repository {} (Git ref: {}) to {}", new Object[]{configuration.getUrl(), configuration.getReference(), localPath});
        CloneCommand cloneCommand = DefaultGitService.createCloneCommand(configuration, localPath);
        try (Git ignored = cloneCommand.call();){
            FileSystemUtils.deleteRecursively((Path)Path.of(String.valueOf(localPath) + File.separator + ".git", new String[0]));
        }
        catch (IOException | GitAPIException e) {
            throw GitException.cloneFailed((Exception)e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getFileContentFromRepository(GitRepositoryConfiguration configuration, String filePath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static CloneCommand createCloneCommand(GitRepositoryConfiguration configuration, Path localPath) {
        CloneCommand cloneCommand = Git.cloneRepository().setURI(configuration.getUrl()).setDepth(1).setDirectory(localPath.toFile());
        cloneCommand.setBranch(configuration.getReference());
        if (StringUtils.hasText((String)configuration.getPassword())) {
            cloneCommand = (CloneCommand)cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(configuration.getUser(), configuration.getPassword()));
        }
        return cloneCommand;
    }
}

