/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.ui;

import ch.admin.bit.jeap.initializer.ui.model.ModuleConfigurationModel;
import ch.admin.bit.jeap.initializer.ui.model.TemplateConfigurationModel;
import ch.admin.bit.jeap.initializer.ui.model.TemplateSelectionModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Base64;
import java.util.Locale;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class ModelConversionConfig
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelConversionConfig.class);
    private final ObjectMapper objectMapper;

    public void addFormatters(FormatterRegistry registry) {
        registry.addFormatterForFieldType(TemplateSelectionModel.class, new WizardStepModelFormatter<TemplateSelectionModel>(TemplateSelectionModel.class));
        registry.addFormatterForFieldType(TemplateConfigurationModel.class, new WizardStepModelFormatter<TemplateConfigurationModel>(TemplateConfigurationModel.class));
        registry.addFormatterForFieldType(ModuleConfigurationModel.class, new WizardStepModelFormatter<ModuleConfigurationModel>(ModuleConfigurationModel.class));
    }

    @Generated
    public ModelConversionConfig(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    class WizardStepModelFormatter<T>
    implements Formatter<T> {
        private final Class<T> targetType;

        public T parse(String base64, Locale locale) throws ParseException {
            try {
                byte[] jsonBytes = Base64.getDecoder().decode(base64);
                return (T)ModelConversionConfig.this.objectMapper.readValue(new String(jsonBytes, StandardCharsets.UTF_8), this.targetType);
            }
            catch (JsonProcessingException e) {
                log.error("Failed to parse JSON string to object", (Throwable)e);
                throw new ParseException(e.getMessage(), (int)e.getLocation().getCharOffset());
            }
        }

        public String print(Object object, Locale locale) {
            try {
                byte[] jsonBytes = ModelConversionConfig.this.objectMapper.writeValueAsBytes(object);
                return Base64.getEncoder().encodeToString(jsonBytes);
            }
            catch (JsonProcessingException e) {
                log.error("Failed to serialize object to JSON string", (Throwable)e);
                throw new IllegalArgumentException(e);
            }
        }

        @Generated
        public WizardStepModelFormatter(Class<T> targetType) {
            this.targetType = targetType;
        }
    }
}

