/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.contributor;

import ch.admin.bit.jeap.initializer.contributor.ProjectContributor;
import ch.admin.bit.jeap.initializer.model.ProjectRequest;
import ch.admin.bit.jeap.initializer.model.ProjectTemplate;
import ch.admin.bit.jeap.initializer.util.FileProcessingException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TemplateFileRenamingContributor
implements ProjectContributor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateFileRenamingContributor.class);
    private static final String REPLACEMENT_ENDING = ".initializer-template";

    @Override
    public void contribute(Path projectRoot, ProjectRequest projectRequest, ProjectTemplate template) {
        try (Stream<Path> pathStream = Files.walk(projectRoot, new FileVisitOption[0]);){
            pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(REPLACEMENT_ENDING)).forEach(this::renameFile);
        }
        catch (IOException e) {
            throw FileProcessingException.ioException("Failed to process files in project root: " + String.valueOf(projectRoot), e);
        }
    }

    private void renameFile(Path originalPath) {
        try {
            String originalFileName = originalPath.getFileName().toString();
            String newFileName = originalFileName.substring(0, originalFileName.length() - REPLACEMENT_ENDING.length());
            Path newPath = originalPath.getParent().resolve(newFileName);
            if (Files.exists(newPath, new LinkOption[0])) {
                Files.delete(newPath);
            }
            Files.move(originalPath, newPath, new CopyOption[0]);
        }
        catch (IOException e) {
            throw FileProcessingException.ioException("Failed to rename file: " + String.valueOf(originalPath), e);
        }
    }
}

