/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.initializer.contributor;

import ch.admin.bit.jeap.initializer.config.JeapInitializerProperties;
import ch.admin.bit.jeap.initializer.contributor.ProjectContributor;
import ch.admin.bit.jeap.initializer.model.ProjectRequest;
import ch.admin.bit.jeap.initializer.model.ProjectTemplate;
import ch.admin.bit.jeap.initializer.util.FileUtils;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CodeRemoverContributor
implements ProjectContributor {
    private static final String BLOCK_START_PREFIX = "START ";
    private static final String BLOCK_END_PREFIX = "END ";
    private final String blockName;
    private final Pattern sourceFilesPattern;

    @Autowired
    public CodeRemoverContributor(JeapInitializerProperties properties) {
        this.blockName = "INITIALIZER DELETE";
        this.sourceFilesPattern = properties.getSourceFilesPattern();
    }

    public CodeRemoverContributor(String blockName, Pattern sourceFilesPattern) {
        this.blockName = blockName;
        this.sourceFilesPattern = sourceFilesPattern;
    }

    @Override
    public void contribute(Path projectRoot, ProjectRequest projectRequest, ProjectTemplate template) {
        FileUtils.removeRegionInFiles(this.sourceFilesPattern, projectRoot, BLOCK_START_PREFIX + this.blockName, BLOCK_END_PREFIX + this.blockName);
    }
}

